/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import java.net.URL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(WeatherConsumer.class);
    private final String query;

    public WeatherConsumer(WeatherEndpoint endpoint, Processor processor, String query) {
        super((Endpoint)endpoint, processor);
        this.query = query;
    }

    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        LOG.debug("Going to execute the Weather query {}", (Object)this.query);
        String weather = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)new URL(this.query));
        LOG.debug("Got back the Weather information {}", (Object)weather);
        if (ObjectHelper.isEmpty((Object)weather)) {
            throw new IllegalStateException("Got the unexpected value '" + weather + "' as the result of the query '" + this.query + "'");
        }
        Exchange exchange = this.getEndpoint().createExchange();
        String header = this.getEndpoint().getConfiguration().getHeaderName();
        if (header != null) {
            exchange.getIn().setHeader(header, (Object)weather);
        } else {
            exchange.getIn().setBody((Object)weather);
        }
        exchange.getIn().setHeader("CamelWeatherQuery", (Object)this.query);
        this.getProcessor().process(exchange);
        return 1;
    }
}

