/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public final class Main {
    private static final String WAR_POSTFIX = ".war";
    private static final String WAR_NAME = "camel-web";
    private static final String WAR_FILENAME = "camel-web.war";
    private static final int KB = 1024;

    private Main() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Welcome to Apache Camel!");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(WAR_FILENAME);
        if (resource == null) {
            System.err.println("Could not find the camel-web.war on classpath!");
            System.exit(1);
        }
        File warFile = File.createTempFile("camel-web-", WAR_POSTFIX);
        System.out.println("Extracting camel-web.war to " + warFile + " ...");
        Main.writeStreamTo(resource.openStream(), new FileOutputStream(warFile), 8192);
        System.out.println("Extracted camel-web.war");
        System.out.println("Launching Jetty Runner...");
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        argsList.add(warFile.getCanonicalPath());
        Class<?> runnerCls = null;
        try {
            runnerCls = Class.forName("org.mortbay.jetty.runner.Runner");
        }
        catch (Throwable t) {
            runnerCls = Class.forName("org.eclipse.jetty.runner.Runner");
        }
        runnerCls.getMethod("main", String[].class).invoke(null, new Object[]{argsList.toArray(new String[argsList.size()])});
        System.exit(0);
    }

    public static int writeStreamTo(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int available = Math.min(input.available(), 262144);
        byte[] buffer = new byte[Math.max(bufferSize, available)];
        int answer = 0;
        int count = input.read(buffer);
        while (count >= 0) {
            output.write(buffer, 0, count);
            answer += count;
            count = input.read(buffer);
        }
        return answer;
    }
}

