/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.view.Viewable;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.ruby.RubyCamel;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.RouteStatusResource;
import org.apache.camel.web.resources.RoutesResource;
import org.apache.camel.web.util.GroovyRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jruby.Main;

public class RouteResource
extends CamelChildResourceSupport {
    public static final String LANGUAGE_XML = "Xml";
    public static final String LANGUAGE_GROOVY = "Groovy";
    public static final String LANGUAGE_RUBY = "Ruby";
    public static final String LANGUAGE_SCALA = "Scala";
    private static final transient Log LOG = LogFactory.getLog(RouteResource.class);
    private RouteDefinition route;
    private String error = "";
    private String id;
    private String language = "Xml";

    public RouteResource(RoutesResource routesResource, RouteDefinition route) {
        super(routesResource.getContextResource());
        this.route = route;
        this.id = route.idOrCreate(route.getCamelContext().getNodeIdFactory());
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public RouteDefinition getRoute() {
        return this.route;
    }

    public String getRouteXml() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.web.model");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)this.route, (Writer)buffer);
        return buffer.toString();
    }

    public String getRouteDefinition() {
        if (this.language.equalsIgnoreCase(LANGUAGE_XML)) {
            try {
                return this.getRouteXml();
            }
            catch (JAXBException e) {
                return "Error on marshal the route definition!";
            }
        }
        if (this.language.equalsIgnoreCase(LANGUAGE_GROOVY)) {
            StringBuilder buffer = new StringBuilder();
            GroovyRenderer.renderRoute((StringBuilder)buffer, (RouteDefinition)this.route);
            return "import org.apache.camel.*;\nimport org.apache.camel.language.groovy.GroovyRouteBuilder;\nclass GroovyRoute extends GroovyRouteBuilder {\nvoid configure() {\n" + buffer.toString() + "\n}\n}";
        }
        return "Unsupported language!";
    }

    @GET
    @Produces(value={"text/vnd.graphviz"})
    public String getDot() throws IOException {
        RouteDotGenerator generator = new RouteDotGenerator("/tmp/camel");
        return generator.getRoutesText(this.getCamelContext());
    }

    @POST
    @Consumes
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public void postRoute(RouteDefinition routeDefinition) throws Exception {
        routeDefinition.setId(this.id);
        this.getCamelContext().addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    public void postRoutes(RouteBuilder builder) throws Exception {
        DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.getCamelContext();
        defaultCamelContext.stopRoute(this.id);
        defaultCamelContext.removeRouteDefinition(this.id);
        defaultCamelContext.addRoutes((RoutesBuilder)builder);
        List routeDefinitions = defaultCamelContext.getRouteDefinitions();
        RouteDefinition route = (RouteDefinition)routeDefinitions.get(routeDefinitions.size() - 1);
        route.setId(this.id);
        defaultCamelContext.startRoute(route);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postRouteForm(@Context UriInfo uriInfo, @FormParam(value="language") String language, @FormParam(value="route") String body, @FormParam(value="edited") String edited) throws URISyntaxException {
        if (edited.equals("false")) {
            return Response.seeOther((URI)new URI("/routes")).build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new Route is: " + body));
        }
        LOG.info((Object)body);
        if (body == null) {
            this.error = "No Route submitted!";
        } else {
            if (language.equals(LANGUAGE_XML)) {
                return this.parseXml(body);
            }
            if (language.equals(LANGUAGE_GROOVY)) {
                return this.parseGroovy(body);
            }
            if (language.equals(LANGUAGE_RUBY)) {
                return this.parseRuby(body);
            }
            if (language.equals(LANGUAGE_SCALA)) {
                return this.parseScala(body);
            }
        }
        this.error = "Not supproted language!";
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private Response parseXml(String xml) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.web.model");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object value = unmarshaller.unmarshal((Reader)new StringReader(xml));
            if (value instanceof RouteDefinition) {
                RouteDefinition routeDefinition = (RouteDefinition)value;
                this.postRoute(routeDefinition);
                return Response.seeOther((URI)new URI("/routes")).build();
            }
            this.error = "Posted XML is not a route but is of type " + ObjectHelper.className((Object)value);
        }
        catch (JAXBException e) {
            this.error = "Failed to parse XML: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to install route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private Response parseGroovy(String route) {
        try {
            GroovyClassLoader classLoader = new GroovyClassLoader();
            Class clazz = classLoader.parseClass(route);
            RouteBuilder builder = (RouteBuilder)clazz.newInstance();
            LOG.info((Object)("Loaded builder: " + builder));
            this.postRoutes(builder);
            return Response.seeOther((URI)new URI("/routes")).build();
        }
        catch (IOException e) {
            this.error = "Failed to store the route: " + e.getMessage();
        }
        catch (InstantiationException e) {
            this.error = "Failed to instantiate the route: " + e.getMessage();
        }
        catch (IllegalAccessException e) {
            this.error = "Failed to instantiate the route: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to edit the route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private Response parseRuby(String route) {
        try {
            route = route + "\n RubyCamel.addRouteBuilder(RubyRoute.new)";
            File file = this.storeRoute(route, LANGUAGE_RUBY);
            String[] args = new String[]{file.getAbsolutePath()};
            Main.main((String[])args);
            List list = RubyCamel.getRoutes();
            for (RouteBuilder builder : list) {
                this.postRoutes(builder);
            }
            return Response.seeOther((URI)new URI("/routes")).build();
        }
        catch (IOException e) {
            this.error = "Failed to store the route: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to edit the route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private Response parseScala(String route) {
        try {
            this.storeRoute(route, LANGUAGE_SCALA);
            return Response.seeOther((URI)new URI("/routes")).build();
        }
        catch (IOException e) {
            this.error = "Failed to store the route: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to edit the route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private File storeRoute(String route, String language) throws IOException {
        File file = File.createTempFile("Route-", "." + language);
        FileWriter fw = new FileWriter(file);
        fw.write(route);
        fw.flush();
        fw.close();
        return file;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language.equalsIgnoreCase(LANGUAGE_GROOVY) ? LANGUAGE_GROOVY : (language.equalsIgnoreCase(LANGUAGE_GROOVY) ? LANGUAGE_GROOVY : (language.equalsIgnoreCase(LANGUAGE_RUBY) ? LANGUAGE_RUBY : (language.equalsIgnoreCase(LANGUAGE_SCALA) ? LANGUAGE_SCALA : LANGUAGE_XML)));
    }

    @Path(value="status")
    public RouteStatusResource getRouteStatus() {
        return new RouteStatusResource(this);
    }

    public String getError() {
        return this.error;
    }
}

