/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.web.util.SendDefinitionRenderer;

public final class CatchDefinitionRenderer {
    private CatchDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        CatchDefinition catchDef = (CatchDefinition)processor;
        buffer.append(".").append(catchDef.getShortName()).append("(");
        List exceptions = catchDef.getExceptionClasses();
        for (Class clazz : exceptions) {
            buffer.append(clazz.getSimpleName()).append(".class");
            if (clazz == exceptions.get(exceptions.size() - 1)) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (catchDef.getHandledPolicy() != null) {
            String handled = catchDef.getHandledPolicy().toString();
            buffer.append(".handled(").append(handled).append(")");
        }
        List branches = catchDef.getOutputs();
        for (ProcessorDefinition branch : branches) {
            SendDefinitionRenderer.render((StringBuilder)buffer, (ProcessorDefinition)branch);
        }
    }
}

