/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetOutHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.web.util.ExpressionRenderer;
import org.apache.camel.web.util.PredicateRenderer;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ExpressionNodeRenderer {
    private ExpressionNodeRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        ExpressionNode expNode = (ExpressionNode)processor;
        buffer.append(".").append(expNode.getShortName());
        if (expNode instanceof DelayDefinition) {
            ExpressionNodeRenderer.renderDelay((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof FilterDefinition) {
            ExpressionNodeRenderer.renderFilter((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof IdempotentConsumerDefinition) {
            ExpressionNodeRenderer.renderIdempotentConsumer((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof LoopDefinition) {
            ExpressionNodeRenderer.renderLoop((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof RecipientListDefinition) {
            ExpressionDefinition expression = expNode.getExpression();
            buffer.append("(");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            buffer.append(")");
        } else if (expNode instanceof SetBodyDefinition) {
            ExpressionNodeRenderer.renderSetBody((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof SetHeaderDefinition) {
            ExpressionNodeRenderer.renderSetHeader((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof SetOutHeaderDefinition) {
            buffer.append("(\"setOutHeaderDefinition\")");
        } else if (expNode instanceof SetPropertyDefinition) {
            ExpressionNodeRenderer.renderSetProperty((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof SplitDefinition) {
            ExpressionNodeRenderer.renderSplit((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof TransformDefinition) {
            ExpressionNodeRenderer.renderTransform((StringBuilder)buffer, (ExpressionNode)expNode);
        } else if (expNode instanceof WhenDefinition) {
            ExpressionNodeRenderer.renderWhen((StringBuilder)buffer, (ExpressionNode)expNode);
        }
    }

    private static void renderDelay(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        String delay = expression.getExpressionValue().toString();
        if (!delay.contains("(")) {
            String delayTime = expression.getExpressionValue().toString();
            buffer.append("(").append(delayTime).append(")");
        } else {
            buffer.append("()");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
    }

    private static void renderFilter(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        if (!(expression instanceof ExpressionClause)) {
            if (expression.getPredicate() != null) {
                buffer.append("(");
                PredicateRenderer.render((StringBuilder)buffer, (Predicate)expression.getPredicate());
                buffer.append(")");
            }
        } else {
            String language = expression.getLanguage();
            if (language != null && !language.equals("")) {
                buffer.append("()");
                ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            } else {
                buffer.append("()");
                ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            }
        }
    }

    private static void renderIdempotentConsumer(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        IdempotentConsumerDefinition idempotentConsume = (IdempotentConsumerDefinition)expNode;
        buffer.append("(");
        ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        buffer.append(", ");
        IdempotentRepository repository = idempotentConsume.getMessageIdRepository();
        if (repository instanceof FileIdempotentRepository) {
            buffer.append("FileIdempotentRepository.fileIdempotentRepository()");
        } else if (repository instanceof MemoryIdempotentRepository) {
            buffer.append("MemoryIdempotentRepository.memoryIdempotentRepository()");
        }
        buffer.append(")");
        if (!idempotentConsume.isEager().booleanValue()) {
            buffer.append(".eager(false)");
        }
    }

    private static void renderLoop(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        if (expression instanceof ConstantExpression) {
            buffer.append("(").append(expression.getExpression()).append(")");
        } else {
            buffer.append("()");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
    }

    private static void renderSetBody(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        String expValue = expression.getExpressionValue().toString();
        if (expValue.startsWith("append")) {
            buffer.append("(");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            buffer.append(")");
        } else {
            buffer.append("()");
            ExpressionRenderer.renderConstant((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
    }

    private static void renderSetHeader(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        SetHeaderDefinition set = (SetHeaderDefinition)expNode;
        buffer.append("(\"").append(set.getHeaderName()).append("\")");
        if (expression.getExpressionValue() != null) {
            ExpressionRenderer.renderConstant((StringBuilder)buffer, (ExpressionDefinition)expression);
        } else if (expression.getExpressionType() != null) {
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
    }

    private static void renderSetProperty(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        SetPropertyDefinition set = (SetPropertyDefinition)expNode;
        buffer.append("(\"").append(set.getPropertyName()).append("\")");
        if (expression.getExpressionValue() != null) {
            ExpressionRenderer.renderConstant((StringBuilder)buffer, (ExpressionDefinition)expression);
        } else if (expression.getExpressionType() != null) {
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
    }

    private static void renderSplit(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        if (expression.getExpressionValue() != null) {
            buffer.append("(");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            buffer.append(")");
        } else if (expression.getExpressionType() != null) {
            buffer.append("().");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        }
        SplitDefinition split = (SplitDefinition)expNode;
        if (split.isStreaming()) {
            buffer.append(".streaming()");
        }
    }

    private static void renderTransform(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        String expValue = expression.getExpressionValue().toString();
        if (expValue.startsWith("append") || expValue.startsWith("prepend") || expValue.startsWith("to")) {
            buffer.append("(");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
            buffer.append(")");
        } else if (expValue.startsWith("xpath")) {
            buffer.append("()");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)expression);
        } else {
            buffer.append("(constant(\"").append(expression.getExpressionValue().toString()).append("\"))");
        }
    }

    private static void renderWhen(StringBuilder buffer, ExpressionNode expNode) {
        ExpressionDefinition expression = expNode.getExpression();
        if (expression.getPredicate() != null) {
            buffer.append("(");
            PredicateRenderer.render((StringBuilder)buffer, (Predicate)expression.getPredicate());
            buffer.append(")");
        }
        if (expression instanceof ExpressionClause) {
            buffer.append("()");
            ExpressionRenderer.render((StringBuilder)buffer, (ExpressionDefinition)((ExpressionClause)expression));
        }
    }
}

