/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.web.util.ErrorHandlerRenderer;
import org.apache.camel.web.util.ProcessorDefinitionRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class GroovyRenderer {
    public static final String HEADER = "import org.apache.camel.*;\nimport org.apache.camel.language.groovy.GroovyRouteBuilder;\nclass GroovyRoute extends GroovyRouteBuilder {\nvoid configure() {\n";
    public static final String FOOTER = "\n}\n}";

    private GroovyRenderer() {
    }

    public static void renderRoute(StringBuilder buffer, RouteDefinition route) {
        List inputs = route.getInputs();
        List outputs = route.getOutputs();
        if (!(route.getErrorHandlerBuilder() instanceof ErrorHandlerBuilderRef)) {
            ErrorHandlerRenderer.render((StringBuilder)buffer, (ErrorHandlerBuilder)route.getErrorHandlerBuilder());
        }
        for (ProcessorDefinition processor : outputs) {
            if (processor.getParent() != null || processor instanceof SendDefinition) continue;
            ProcessorDefinitionRenderer.render((StringBuilder)buffer, (ProcessorDefinition)processor);
            buffer.append(";");
        }
        buffer.append("from(");
        for (FromDefinition input : inputs) {
            buffer.append("\"").append(input.getUri()).append("\"");
            if (input == inputs.get(inputs.size() - 1)) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (route.isTrace() != null) {
            if (route.isTrace().booleanValue()) {
                buffer.append(".tracing()");
            } else {
                buffer.append(".noTracing()");
            }
        }
        if (route.isStreamCache() != null && route.isStreamCache().booleanValue()) {
            buffer.append(".streamCaching()");
        }
        for (ProcessorDefinition processor : outputs) {
            if (processor.getParent() != route && !(processor instanceof SendDefinition)) continue;
            ProcessorDefinitionRenderer.render((StringBuilder)buffer, (ProcessorDefinition)processor);
        }
    }

    public static void renderRoutes(StringBuilder buffer, List<RouteDefinition> routes) {
        for (RouteDefinition route : routes) {
            GroovyRenderer.renderRoute((StringBuilder)buffer, (RouteDefinition)route);
            if (route == routes.get(routes.size() - 1)) continue;
            buffer.append(";\n");
        }
    }
}

