/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.processor.loadbalancer.StickyLoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.web.util.ExpressionRenderer;
import org.apache.camel.web.util.ProcessorDefinitionRenderer;

public final class LoadBalanceDefinitionRenderer {
    private LoadBalanceDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        LoadBalanceDefinition loadB = (LoadBalanceDefinition)processor;
        buffer.append(".").append("loadBalance").append("()");
        LoadBalancer lb = loadB.getLoadBalancerType().getLoadBalancer(null);
        if (lb instanceof FailOverLoadBalancer) {
            buffer.append(".failover(");
            List exceptions = ((FailOverLoadBalancer)lb).getExceptions();
            for (Class excep : exceptions) {
                buffer.append(excep.getSimpleName()).append(".class");
                if (excep == exceptions.get(exceptions.size() - 1)) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        } else if (lb instanceof RandomLoadBalancer) {
            buffer.append(".random()");
        } else if (lb instanceof RoundRobinLoadBalancer) {
            buffer.append(".roundRobin()");
        } else if (lb instanceof StickyLoadBalancer) {
            buffer.append(".sticky(");
            ExpressionRenderer.renderExpression((StringBuilder)buffer, (String)((StickyLoadBalancer)lb).getCorrelationExpression().toString());
            buffer.append(")");
        } else if (lb instanceof TopicLoadBalancer) {
            buffer.append(".topic()");
        }
        List branches = loadB.getOutputs();
        for (ProcessorDefinition branch : branches) {
            ProcessorDefinitionRenderer.render((StringBuilder)buffer, (ProcessorDefinition)branch);
        }
    }
}

