/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.web.util.SendDefinitionRenderer;

public final class OnExceptionDefinitionRenderer {
    private OnExceptionDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        String handledPolicy;
        boolean notGlobal = buffer.toString().endsWith(")");
        if (notGlobal) {
            buffer.append(".");
        }
        OnExceptionDefinition onException = (OnExceptionDefinition)processor;
        buffer.append(processor.getShortName()).append("(");
        List exceptions = onException.getExceptionClasses();
        for (Class excep : exceptions) {
            buffer.append(excep.getSimpleName()).append(".class");
            if (excep == exceptions.get(exceptions.size() - 1)) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (onException.getRedeliveryPolicy() != null) {
            long redeliverDelay;
            int maxRedeliveries;
            RedeliveryPolicyDefinition redelivery = onException.getRedeliveryPolicy();
            if (redelivery.getMaximumRedeliveries() != null && (maxRedeliveries = redelivery.getMaximumRedeliveries().intValue()) != 0) {
                buffer.append(".maximumRedeliveries(").append(maxRedeliveries).append(")");
            }
            if (redelivery.getRedeliveryDelay() != null && (redeliverDelay = redelivery.getRedeliveryDelay().longValue()) != 1000L) {
                buffer.append(".redeliverDelay(").append(redeliverDelay).append(")");
            }
            if (redelivery.getLogStackTrace() != null && redelivery.getLogStackTrace().booleanValue()) {
                buffer.append(".logStackTrace(true)");
            }
        }
        if (onException.getHandledPolicy() != null && (handledPolicy = onException.getHandledPolicy().toString()).equals("false")) {
            buffer.append(".handled(").append(handledPolicy).append(")");
        }
        List branches = onException.getOutputs();
        for (ProcessorDefinition branch : branches) {
            SendDefinitionRenderer.render((StringBuilder)buffer, (ProcessorDefinition)branch);
        }
    }
}

