/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.Predicate;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PredicateRenderer {
    private PredicateRenderer() {
    }

    public static void render(StringBuilder buffer, Predicate predicate) {
        String pre = predicate.toString();
        if (pre.startsWith("not (")) {
            PredicateRenderer.renderNot((StringBuilder)buffer, (String)pre);
        } else if (pre.contains(") and (")) {
            PredicateRenderer.renderAnd((StringBuilder)buffer, (String)pre);
        } else if (pre.contains(") or (")) {
            PredicateRenderer.renderOr((StringBuilder)buffer, (String)pre);
        } else if (pre.startsWith("in (")) {
            PredicateRenderer.renderIn((StringBuilder)buffer, (String)pre);
        } else if (pre.contains(".matches(")) {
            PredicateRenderer.renderMatches((StringBuilder)buffer, (String)pre);
        } else {
            PredicateRenderer.render((StringBuilder)buffer, (String)pre);
        }
    }

    public static void render(StringBuilder buffer, String predicate) {
        String left = predicate.substring(0, predicate.indexOf(" "));
        String opAndRight = predicate.substring(left.length() + 1, predicate.length());
        String operation = opAndRight.substring(0, opAndRight.indexOf(" "));
        String right = opAndRight.substring(operation.length() + 1, opAndRight.length());
        if (operation.equals("is") && right.startsWith("not")) {
            operation = "is not";
            right = right.substring(4, right.length());
        }
        PredicateRenderer.renderLeft((StringBuilder)buffer, (String)left);
        PredicateRenderer.renderOperation((StringBuilder)buffer, (String)operation);
        PredicateRenderer.renderRight((StringBuilder)buffer, (String)right);
    }

    private static void renderAnd(StringBuilder buffer, String predicate) {
        buffer.append("and(");
        String predicate1 = predicate.substring(1, predicate.indexOf(") and ("));
        String predicate2 = predicate.substring(predicate.indexOf(") and (") + 7, predicate.length() - 1);
        PredicateRenderer.render((StringBuilder)buffer, (String)predicate1);
        buffer.append(", ");
        PredicateRenderer.render((StringBuilder)buffer, (String)predicate2);
        buffer.append(")");
    }

    private static void renderIn(StringBuilder buffer, String predicate) {
        String[] predicates = predicate.split("in \\(\\[|,\\s+|\\]\\)");
        if (predicate.contains("convertToEvaluatedType")) {
            String left = predicate.substring(predicate.indexOf("in ([") + 5, predicate.indexOf(" == "));
            PredicateRenderer.renderLeft((StringBuilder)buffer, (String)left);
            buffer.append(".in(");
            for (String pre : predicates) {
                if (pre.equals("")) continue;
                String value = pre.substring(pre.indexOf(" == ") + 4, pre.indexOf(".convertToEvaluatedType("));
                buffer.append("\"").append(value).append("\"");
                if (pre == predicates[predicates.length - 1]) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        } else {
            buffer.append("in(");
            for (String pre : predicates) {
                if (pre.equals("")) continue;
                PredicateRenderer.render((StringBuilder)buffer, (String)pre);
                if (pre == predicates[predicates.length - 1]) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
    }

    private static void renderLeft(StringBuilder buffer, String left) {
        if (left.contains("(")) {
            buffer.append(left.replaceAll("\\(", "(\"").replaceAll("\\)", "\")"));
        } else {
            buffer.append(left).append("()");
        }
    }

    private static void renderMatches(StringBuilder buffer, String pre) {
        pre = pre.replaceFirst("\\(", "(\"").replaceFirst("\\)", "\")");
        pre = pre.replaceFirst(".matches\\('", ".regex(\"").replaceFirst("'\\)", "\")");
        buffer.append(pre);
    }

    private static void renderNot(StringBuilder buffer, String predicate) {
        buffer.append("not(");
        String notPredicate = predicate.substring(predicate.indexOf("(") + 1, predicate.length() - 1);
        PredicateRenderer.render((StringBuilder)buffer, (String)notPredicate);
        buffer.append(")");
    }

    private static void renderOperation(StringBuilder buffer, String operation) {
        if (operation.equals("==")) {
            buffer.append(".isEqualTo");
        } else if (operation.equals("!=")) {
            buffer.append(".isNotEqualTo");
        } else if (operation.equals("<")) {
            buffer.append(".isLessThan");
        } else if (operation.equals("<=")) {
            buffer.append(".isLessThanOrEqualTo");
        } else if (operation.equals(">")) {
            buffer.append(".isGreaterThan");
        } else if (operation.equals(">=")) {
            buffer.append(".isGreaterThanOrEqualTo");
        } else if (operation.equals("contains")) {
            buffer.append(".contains");
        } else if (operation.equals("is")) {
            buffer.append(".isNull()");
        } else if (operation.equals("is not")) {
            buffer.append(".isNotNull()");
        } else if (operation.equals("instanceof")) {
            buffer.append(".isInstanceOf");
        } else if (operation.equals("startsWith")) {
            buffer.append(".startsWith");
        } else if (operation.equals("endsWith")) {
            buffer.append(".endsWith");
        } else if (operation.equals("matches")) {
            buffer.append(".regex");
        }
    }

    private static void renderOr(StringBuilder buffer, String predicate) {
        buffer.append("or(");
        String predicate1 = predicate.substring(1, predicate.indexOf(") or ("));
        String predicate2 = predicate.substring(predicate.indexOf(") or (") + 6, predicate.length() - 1);
        PredicateRenderer.render((StringBuilder)buffer, (String)predicate1);
        buffer.append(", ");
        PredicateRenderer.render((StringBuilder)buffer, (String)predicate2);
        buffer.append(")");
    }

    private static void renderRight(StringBuilder buffer, String right) {
        if (right.matches("-?\\d+")) {
            buffer.append("(").append(right).append(")");
        } else {
            if (right.equals("") || right.equals("null")) {
                return;
            }
            if (right.startsWith("java.")) {
                String className = right.substring(right.lastIndexOf(".") + 1, right.length());
                buffer.append("(").append(className).append(".class)");
            } else {
                buffer.append("(\"").append(right).append("\")");
            }
        }
    }
}

