/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.web.util.ExpressionRenderer;

public final class ResequenceDefinitionRenderer {
    private ResequenceDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        ResequenceDefinition resequence = (ResequenceDefinition)processor;
        buffer.append(".").append(processor.getShortName()).append("(");
        List exps = resequence.getExpressionList();
        for (Expression exp : exps) {
            ExpressionRenderer.renderExpression((StringBuilder)buffer, (String)exp.toString());
            if (exp == exps.get(exps.size() - 1)) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (resequence.getStreamConfig() != null) {
            buffer.append(".stream()");
        }
    }
}

