/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.web.util.ExpressionRenderer;

public final class SendDefinitionRenderer {
    private SendDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition processor) {
        buffer.append(".");
        SendDefinition send = (SendDefinition)processor;
        if (send instanceof WireTapDefinition) {
            buffer.append(send.getShortName());
            buffer.append("(\"").append(send.getUri());
            WireTapDefinition wireTap = (WireTapDefinition)send;
            if (wireTap.getNewExchangeExpression() != null) {
                String expression = wireTap.getNewExchangeExpression().toString();
                buffer.append("\", ");
                ExpressionRenderer.renderConstant((StringBuilder)buffer, (String)expression);
                buffer.append(")");
            } else {
                buffer.append("\")");
            }
        } else if (send.getPattern() == null) {
            buffer.append(send.getShortName());
            buffer.append("(\"").append(send.getUri()).append("\")");
        } else {
            if (send.getPattern().name().equals("InOnly")) {
                buffer.append("inOnly");
            } else if (send.getPattern().name().equals("InOut")) {
                buffer.append("inOut");
            }
            buffer.append("(\"").append(send.getUri()).append("\")");
        }
    }
}

