/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.model;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.web.util.JMXRouteStatistics;
import org.apache.camel.web.util.RouteStatistics;

public class Route {
    private CamelContext camelContext;
    private RouteDefinition route;
    private final RouteStatistics statistics = new JMXRouteStatistics();

    public Route() {
    }

    public Route(CamelContext camelContext, RouteDefinition route) {
        this.camelContext = camelContext;
        this.route = route;
    }

    public String getId() {
        return this.route.getId();
    }

    public String idOrCreate() {
        return this.route.idOrCreate(this.camelContext.getNodeIdFactory());
    }

    public DescriptionDefinition getDescription() {
        return this.route.getDescription();
    }

    public String getDescriptionText() {
        DescriptionDefinition definition = this.getDescription();
        return definition != null ? definition.getText() : "";
    }

    public ServiceStatus getStatus() {
        return this.route.getStatus(this.camelContext);
    }

    public boolean isStartable() {
        return this.route.isStartable(this.camelContext);
    }

    public boolean isStoppable() {
        return this.route.isStoppable(this.camelContext);
    }

    public Object getStatistic(String attribute) {
        Object answer = this.statistics.getRouteStatistic(this.camelContext, this.route.getId(), attribute);
        if (answer == null) {
            return "";
        }
        return answer;
    }
}

