/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.view.ImplicitProduces;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ImplicitProduces(value={"text/html;qs=5"})
public class CamelChildResourceSupport {
    private static final transient Log LOG = LogFactory.getLog(CamelChildResourceSupport.class);
    private final CamelContext camelContext;
    private final ProducerTemplate template;
    private CamelContextResource contextResource;

    public CamelChildResourceSupport(CamelContextResource contextResource) {
        this.contextResource = contextResource;
        this.camelContext = contextResource.getCamelContext();
        this.template = contextResource.getTemplate();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public ProducerTemplate getTemplate() {
        return this.template;
    }

    public CamelContextResource getContextResource() {
        return this.contextResource;
    }

    public DefaultTypeConverter getDefaultTypeConverter() {
        TypeConverterRegistry converterRegistry = this.getCamelContext().getTypeConverterRegistry();
        if (converterRegistry instanceof DefaultTypeConverter) {
            return (DefaultTypeConverter)converterRegistry;
        }
        LOG.info((Object)("Not a default type converter as it is: " + converterRegistry));
        return null;
    }
}

