/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.api.view.ImplicitProduces;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PreDestroy;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.web.model.Camel;
import org.apache.camel.web.resources.ComponentsResource;
import org.apache.camel.web.resources.ConvertersResource;
import org.apache.camel.web.resources.EndpointsResource;
import org.apache.camel.web.resources.LanguagesResource;
import org.apache.camel.web.resources.RoutesResource;

@Path(value="/")
@ImplicitProduces(value={"text/html;qs=5"})
@Singleton
public class CamelContextResource {
    private CamelContext camelContext;
    private ProducerTemplate template;

    public CamelContextResource(@InjectParam CamelContext camelContext) throws Exception {
        this.camelContext = camelContext;
        this.template = camelContext.createProducerTemplate();
        this.template.start();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public ProducerTemplate getTemplate() {
        return this.template;
    }

    public String getName() {
        return this.camelContext.getName();
    }

    public String getVersion() {
        if (this.camelContext instanceof ServiceSupport) {
            ServiceSupport serviceSupport = (ServiceSupport)this.camelContext;
            return serviceSupport.getVersion();
        }
        return null;
    }

    @PreDestroy
    public void close() throws Exception {
        if (this.template != null) {
            this.template.stop();
        }
    }

    public Map<Object, Object> getSystemProperties() {
        return new TreeMap<Object, Object>(System.getProperties());
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public Camel getCamel() {
        return new Camel(this.camelContext, this.getVersion());
    }

    @Path(value="components")
    public ComponentsResource getComponents() {
        return new ComponentsResource(this);
    }

    @Path(value="converters")
    public ConvertersResource getConvertersResource() {
        return new ConvertersResource(this);
    }

    @Path(value="endpoints")
    public EndpointsResource getEndpointsResource() {
        return new EndpointsResource(this);
    }

    @Path(value="languages")
    public LanguagesResource getLanguages() {
        return new LanguagesResource(this);
    }

    @Path(value="routes")
    public RoutesResource getRoutesResource() {
        return new RoutesResource(this);
    }
}

