/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.util.resource.Resource;

public class JettyClassPathResource
extends Resource {
    private final ClassResolver resolver;
    private final String path;

    public JettyClassPathResource(ClassResolver resolver, String path) {
        ObjectHelper.notNull((Object)resolver, (String)"ClassResolver");
        ObjectHelper.notNull((Object)path, (String)"path");
        this.resolver = resolver;
        this.path = path;
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    public void release() {
    }

    public boolean exists() {
        InputStream is = this.resolver.loadResourceAsStream(this.path);
        if (is != null) {
            IOHelper.close((Closeable)is);
        }
        return is != null;
    }

    public boolean isDirectory() {
        return this.exists() && this.path.endsWith("/");
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public URL getURL() {
        return this.resolver.loadResourceAsURL(this.path);
    }

    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            return new File(url.getFile());
        }
        return null;
    }

    public String getName() {
        return this.path;
    }

    public InputStream getInputStream() throws IOException {
        return this.resolver.loadResourceAsStream(this.path);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return null;
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    public String[] list() {
        return new String[0];
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        return new JettyClassPathResource(this.resolver, this.path + "/" + path);
    }
}

