/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity;

import java.util.Map;
import javax.xml.crypto.URIDereferencer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmlsecurity.XmlSignatureComponent;
import org.apache.camel.component.xmlsecurity.XmlSignatureProducer;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.impl.DefaultEndpoint;

public abstract class XmlSignatureEndpoint
extends DefaultEndpoint {
    public XmlSignatureEndpoint(String uri, XmlSignatureComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() {
        return new XmlSignatureProducer((Endpoint)this, this.createProcessor());
    }

    abstract Processor createProcessor();

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("XML Signature endpoints are not meant to be consumed from.");
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getManagedObject(XmlSignatureEndpoint endpoint) {
        return this;
    }

    public abstract XmlSignatureConfiguration getConfiguration();

    public URIDereferencer getUriDereferencer() {
        return this.getConfiguration().getUriDereferencer();
    }

    public void setUriDereferencer(URIDereferencer uriDereferencer) {
        this.getConfiguration().setUriDereferencer(uriDereferencer);
    }

    public String getBaseUri() {
        return this.getConfiguration().getBaseUri();
    }

    public void setBaseUri(String baseUri) {
        this.getConfiguration().setBaseUri(baseUri);
    }

    public Map<String, ? extends Object> getCryptoContextProperties() {
        return this.getConfiguration().getCryptoContextProperties();
    }

    public void setCryptoContextProperties(Map<String, ? extends Object> cryptoContextProperties) {
        this.getConfiguration().setCryptoContextProperties(cryptoContextProperties);
    }

    public Boolean getDisallowDoctypeDecl() {
        return this.getConfiguration().getDisallowDoctypeDecl();
    }

    public void setDisallowDoctypeDecl(Boolean disallowDoctypeDecl) {
        this.getConfiguration().setDisallowDoctypeDecl(disallowDoctypeDecl);
    }

    public Boolean getOmitXmlDeclaration() {
        return this.getConfiguration().getOmitXmlDeclaration();
    }

    public void setOmitXmlDeclaration(Boolean omitXmlDeclaration) {
        this.getConfiguration().setOmitXmlDeclaration(omitXmlDeclaration);
    }

    public String getSchemaResourceUri() {
        return this.getConfiguration().getSchemaResourceUri();
    }

    public void setSchemaResourceUri(String schemaResourceUri) {
        this.getConfiguration().setSchemaResourceUri(schemaResourceUri);
    }
}

