/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.SignatureType;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureFormatException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureInvalidKeyException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureNoKeyException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureProcessor;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlSignerProcessor
extends XmlSignatureProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignerProcessor.class);
    private static final String SHA512 = "sha512";
    private static final String SHA384 = "sha384";
    private static final String SHA256 = "sha256";
    private static final String SHA224 = "sha224";
    private static final String SHA1 = "sha1";
    private static final String RIPEMD160 = "ripemd160";
    private static final String HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#sha224";
    private static final String HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    private final XmlSignerConfiguration config;

    public XmlSignerProcessor(XmlSignerConfiguration config) {
        this.config = config;
    }

    @Override
    public XmlSignerConfiguration getConfiguration() {
        return this.config;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            LOG.debug("XML signature generation started using algorithm {} and canonicalization method {}", (Object)this.getConfiguration().getSignatureAlgorithm(), (Object)this.getConfiguration().getCanonicalizationMethod().getAlgorithm());
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            Document outputDoc = this.sign(out);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XmlSignatureHelper.transformNonTextNodeToOutputStream(outputDoc, outStream, this.omitXmlDeclaration(out), this.getConfiguration().getOutputXmlEncoding());
            byte[] data = outStream.toByteArray();
            out.setBody((Object)data);
            this.setOutputEncodingToMessageHeader(out);
            this.clearMessageHeaders(out);
            LOG.debug("XML signature generation finished");
        }
        catch (Exception e) {
            exchange.setOut(null);
            throw e;
        }
    }

    protected Document sign(Message out) throws Exception {
        try {
            XMLSignatureFactory fac;
            try {
                fac = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
            }
            catch (NoSuchProviderException ex) {
                fac = XMLSignatureFactory.getInstance("DOM");
            }
            Node node = this.getMessageBodyNode(out);
            if (this.getConfiguration().getKeyAccessor() == null) {
                throw new XmlSignatureNoKeyException("Key accessor is missing for XML signature generation. Specify a key accessor in the configuration.");
            }
            KeySelector keySelector = this.getConfiguration().getKeyAccessor().getKeySelector(out);
            if (keySelector == null) {
                throw new XmlSignatureNoKeyException("Key selector is missing for XML signature generation. Specify a key selector in the configuration.");
            }
            SignatureType signatureType = this.determineSignatureType(out);
            List<String> contentReferenceUris = this.getContentReferenceUris(out, signatureType, node);
            Element lastParent = null;
            for (String contentReferenceUri : contentReferenceUris) {
                KeyInfo keyInfo = this.getConfiguration().getKeyAccessor().getKeyInfo(out, node, fac.getKeyInfoFactory());
                String signatureId = this.getConfiguration().getSignatureId();
                if (signatureId == null) {
                    signatureId = "_" + UUID.randomUUID().toString();
                } else if (signatureId.isEmpty()) {
                    signatureId = null;
                }
                Node parent = this.getParentOfSignature(out, node, contentReferenceUri, signatureType);
                if (parent == null) {
                    parent = XmlSignatureHelper.newDocumentBuilder(Boolean.TRUE).newDocument();
                }
                lastParent = parent;
                XmlSignatureProperties.Input input = new InputBuilder().contentDigestAlgorithm(this.getDigestAlgorithmUri()).keyInfo(keyInfo).message(out).messageBodyNode(node).parent(parent).signatureAlgorithm(this.getConfiguration().getSignatureAlgorithm()).signatureFactory(fac).signatureId(signatureId).contentReferenceUri(contentReferenceUri).signatureType(signatureType).prefixForXmlSignatureNamespace(this.getConfiguration().getPrefixForXmlSignatureNamespace()).build();
                XmlSignatureProperties.Output properties = this.getSignatureProperties(input);
                if (properties != null && properties.getSignatureId() != null && !properties.getSignatureId().isEmpty()) {
                    signatureId = properties.getSignatureId();
                }
                List<? extends XMLObject> objects = this.getObjects(input, properties);
                List<? extends Reference> refs = this.getReferences(input, properties, this.getKeyInfoId(keyInfo));
                SignedInfo si = this.createSignedInfo(fac, refs);
                DOMSignContext dsc = this.createAndConfigureSignContext(parent, keySelector);
                XMLSignature signature = fac.newXMLSignature(si, keyInfo, objects, signatureId, null);
                signature.sign(dsc);
            }
            return XmlSignatureHelper.getDocument(lastParent);
        }
        catch (XMLSignatureException se) {
            if (se.getCause() instanceof InvalidKeyException) {
                throw new XmlSignatureInvalidKeyException(se.getMessage(), se);
            }
            throw new XmlSignatureException(se);
        }
        catch (GeneralSecurityException e) {
            throw new XmlSignatureException(e);
        }
    }

    private SignatureType determineSignatureType(Message message) throws XmlSignatureException {
        SignatureType result;
        boolean isDetached;
        if (this.getConfiguration().getParentLocalName() != null && this.getConfiguration().getParentXpath() != null) {
            throw new XmlSignatureException("The configuration of the XML signer component is wrong. The parent local name " + this.getConfiguration().getParentLocalName() + " and the parent XPath " + this.getConfiguration().getParentXpath().getXPath() + " are specified. You must not specify both parameters.");
        }
        boolean isEnveloped = this.getConfiguration().getParentLocalName() != null || this.getConfiguration().getParentXpath() != null;
        boolean bl = isDetached = this.getXpathToIdAttributes(message).size() > 0;
        if (isEnveloped && isDetached) {
            if (this.getConfiguration().getParentLocalName() != null) {
                throw new XmlSignatureException("The configuration of the XML signer component is wrong. The parent local name " + this.getConfiguration().getParentLocalName() + " for an enveloped signature and the XPATHs to ID attributes for a detached signature are specified. You must not specify both parameters.");
            }
            throw new XmlSignatureException("The configuration of the XML signer component is wrong. The parent XPath " + this.getConfiguration().getParentXpath().getXPath() + " for an enveloped signature and the XPATHs to ID attributes for a detached signature are specified. You must not specify both parameters.");
        }
        if (isEnveloped) {
            result = SignatureType.enveloped;
        } else if (isDetached) {
            if (this.getSchemaResourceUri(message) == null) {
                throw new XmlSignatureException("The configruation of the XML Signature component is wrong: No XML schema specified in the detached case");
            }
            result = SignatureType.detached;
        } else {
            result = SignatureType.enveloping;
        }
        LOG.debug("Signature type: {}", (Object)result);
        return result;
    }

    protected List<XPathFilterParameterSpec> getXpathToIdAttributes(Message message) {
        List<XPathFilterParameterSpec> result = (List<XPathFilterParameterSpec>)message.getHeader("CamelXmlSignatureXpathsToIdAttributes");
        if (result == null) {
            result = this.getConfiguration().getXpathsToIdAttributes();
        }
        return result;
    }

    protected XmlSignatureProperties.Output getSignatureProperties(XmlSignatureProperties.Input input) throws Exception {
        XmlSignatureProperties propGetter = this.getConfiguration().getProperties();
        XmlSignatureProperties.Output propsOutput = null;
        if (propGetter != null) {
            propsOutput = propGetter.get(input);
        }
        return propsOutput;
    }

    private DOMSignContext createAndConfigureSignContext(Node parent, KeySelector keySelector) {
        DOMSignContext dsc = new DOMSignContext(keySelector, parent);
        if (this.getConfiguration().getPrefixForXmlSignatureNamespace() != null && !this.getConfiguration().getPrefixForXmlSignatureNamespace().isEmpty()) {
            dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.getConfiguration().getPrefixForXmlSignatureNamespace());
        }
        dsc.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
        this.setCryptoContextProperties(dsc);
        this.setUriDereferencerAndBaseUri(dsc);
        return dsc;
    }

    protected Boolean omitXmlDeclaration(Message message) {
        Boolean omitXmlDeclaration = (Boolean)message.getHeader("CamelXmlSignatureOmitXmlDeclaration", Boolean.class);
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = this.getConfiguration().getOmitXmlDeclaration();
        }
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = Boolean.FALSE;
        }
        LOG.debug("Omit XML declaration: {}", (Object)omitXmlDeclaration);
        return omitXmlDeclaration;
    }

    protected SignedInfo createSignedInfo(XMLSignatureFactory fac, List<? extends Reference> refs) throws Exception {
        return fac.newSignedInfo(fac.newCanonicalizationMethod(this.getConfiguration().getCanonicalizationMethod().getAlgorithm(), (C14NMethodParameterSpec)this.getConfiguration().getCanonicalizationMethod().getParameterSpec()), this.getSignatureMethod(this.getConfiguration().getSignatureAlgorithm(), fac), refs);
    }

    private SignatureMethod getSignatureMethod(String signatureAlgorithm, XMLSignatureFactory fac) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return fac.newSignatureMethod(signatureAlgorithm, null);
    }

    protected Node getMessageBodyNode(Message message) throws Exception {
        Node node;
        InputStream is = (InputStream)message.getMandatoryBody(InputStream.class);
        Boolean isPlainText = this.isPlainText(message);
        if (isPlainText != null && isPlainText.booleanValue()) {
            node = this.getTextNode(message, is);
        } else {
            DefaultValidationErrorHandler errorHandler = new DefaultValidationErrorHandler();
            Schema schema = this.getSchemaForSigner(message, (ValidatorErrorHandler)errorHandler);
            Document doc = this.parseInput(is, this.getConfiguration().getDisallowDoctypeDecl(), schema, (ErrorHandler)errorHandler);
            errorHandler.handleErrors(message.getExchange(), schema, null);
            node = doc.getDocumentElement();
            LOG.debug("Root element of document to be signed: {}", (Object)node);
        }
        return node;
    }

    protected Schema getSchemaForSigner(Message message, ValidatorErrorHandler errorHandler) throws XmlSignatureException, SAXException, IOException {
        String schemaResourceUri = this.getSchemaResourceUri(message);
        Schema schema = schemaResourceUri == null ? null : this.getSchema(message);
        return schema;
    }

    protected Boolean isPlainText(Message message) {
        Boolean isPlainText = (Boolean)message.getHeader("CamelXmlSignatureMessageIsPlainText", Boolean.class);
        if (isPlainText == null) {
            isPlainText = this.getConfiguration().getPlainText();
        }
        LOG.debug("Is plain text: {}", (Object)isPlainText);
        return isPlainText;
    }

    protected Element getParentOfSignature(Message inMessage, Node messageBodyNode, String contentReferenceURI, SignatureType sigType) throws Exception {
        if (SignatureType.enveloping == sigType) {
            return null;
        }
        if (messageBodyNode.getParentNode() == null || messageBodyNode.getParentNode().getNodeType() != 9) {
            throw new XmlSignatureFormatException("Incomming message has wrong format: It is not an XML document. Cannot create an enveloped or detached XML signature.");
        }
        Document doc = (Document)messageBodyNode.getParentNode();
        if (SignatureType.detached == sigType) {
            return this.getParentForDetachedCase(doc, inMessage, contentReferenceURI);
        }
        return this.getParentForEnvelopedCase(doc, inMessage);
    }

    protected Element getParentForEnvelopedCase(Document doc, Message inMessage) throws Exception {
        if (this.getConfiguration().getParentXpath() != null) {
            XPathExpression exp;
            XPathFilterParameterSpec xp = this.getConfiguration().getParentXpath();
            try {
                exp = XmlSignatureHelper.getXPathExpression(xp);
            }
            catch (XPathExpressionException e) {
                throw new XmlSignatureException("The parent XPath " + this.getConfiguration().getParentXpath().getXPath() + " is wrongly configured: The XPath " + xp.getXPath() + " is invalid.", e);
            }
            NodeList list = (NodeList)exp.evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
            if (list == null || list.getLength() == 0) {
                throw new XmlSignatureException("The parent XPath " + xp.getXPath() + " returned no result. Check the configuration of the XML signer component.");
            }
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
            throw new XmlSignatureException("The parent XPath " + xp.getXPath() + " returned no element. Check the configuration of the XML signer component.");
        }
        NodeList parents = doc.getElementsByTagNameNS(this.getConfiguration().getParentNamespace(), this.getConfiguration().getParentLocalName());
        if (parents == null || parents.getLength() == 0) {
            throw new XmlSignatureFormatException(String.format("Incoming message has wrong format: The parent element with the local name %s and the namespace %s was not found in the message to build an enveloped XML signature.", this.getConfiguration().getParentLocalName(), this.getConfiguration().getParentNamespace()));
        }
        return (Element)parents.item(0);
    }

    private Element getParentForDetachedCase(Document doc, Message inMessage, String referenceUri) throws XmlSignatureException {
        Element el;
        String elementId = referenceUri;
        if (elementId.startsWith("#")) {
            elementId = elementId.substring(1);
        }
        if ((el = doc.getElementById(elementId)) == null) {
            throw new IllegalStateException("No element found for element ID " + elementId);
        }
        LOG.debug("Sibling element of the detached XML Signature with reference URI {}: {}  {} ", new Object[]{referenceUri, el.getLocalName(), el.getNamespaceURI()});
        Element result = this.getParentElement(el);
        if (result != null) {
            return result;
        }
        throw new XmlSignatureException("Either the configuration of the XML Signature component is wrong or the incoming document has an invalid structure: The element " + el.getLocalName() + "{" + el.getNamespaceURI() + "} which is referenced by the reference URI " + referenceUri + " has no parent element. The element must have a parent element in the configured detached case.");
    }

    private Element getParentElement(Node node) {
        for (int counter = 0; node != null && counter < 10000; ++counter) {
            Node parent = node.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                return (Element)parent;
            }
            node = parent;
        }
        return null;
    }

    protected List<? extends Reference> getReferences(XmlSignatureProperties.Input input, XmlSignatureProperties.Output properties, String keyInfoId) throws Exception {
        String referenceId = properties == null ? null : properties.getContentReferenceId();
        Reference ref = this.createReference(input.getSignatureFactory(), input.getContentReferenceUri(), this.getContentReferenceType(input.getMessage()), input.getSignatureType(), referenceId);
        Reference keyInfoRef = this.createKeyInfoReference(input.getSignatureFactory(), keyInfoId, input.getContentDigestAlgorithm());
        int propsRefsSize = properties == null || properties.getReferences() == null || properties.getReferences().isEmpty() ? 0 : properties.getReferences().size();
        int size = keyInfoRef == null ? propsRefsSize + 1 : propsRefsSize + 2;
        ArrayList<? extends Reference> referenceList = new ArrayList<Reference>(size);
        referenceList.add(ref);
        if (keyInfoRef != null) {
            referenceList.add(keyInfoRef);
        }
        if (properties != null && properties.getReferences() != null && !properties.getReferences().isEmpty()) {
            referenceList.addAll(properties.getReferences());
        }
        return referenceList;
    }

    protected List<? extends XMLObject> getObjects(XmlSignatureProperties.Input input, XmlSignatureProperties.Output properties) throws Exception {
        if (SignatureType.enveloped == input.getSignatureType() || SignatureType.detached == input.getSignatureType()) {
            if (properties == null || properties.getObjects() == null) {
                return Collections.emptyList();
            }
            return properties.getObjects();
        }
        String objectId = this.getConfiguration().getContentObjectId();
        LOG.debug("Object Content Id {}", (Object)objectId);
        XMLObject obj = this.createXMLObject(input.getSignatureFactory(), input.getMessageBodyNode(), objectId);
        if (properties == null || properties.getObjects() == null || properties.getObjects().isEmpty()) {
            return Collections.singletonList(obj);
        }
        ArrayList<? extends XMLObject> result = new ArrayList<XMLObject>(properties.getObjects().size() + 1);
        result.add(obj);
        result.addAll(properties.getObjects());
        return result;
    }

    private Node getTextNode(Message inMessage, InputStream is) throws IOException, ParserConfigurationException, XmlSignatureException {
        LOG.debug("Message body to be signed is plain text");
        String encoding = this.getMessageEncoding(inMessage);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
        try {
            String text = new String(bos.toByteArray(), encoding);
            return XmlSignatureHelper.newDocumentBuilder(true).newDocument().createTextNode(text);
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlSignatureException(String.format("The message encoding %s is not supported.", encoding), e);
        }
    }

    protected String getMessageEncoding(Message inMessage) {
        String encoding = (String)inMessage.getHeader("CamelXmlSignaturePlainTextEncoding", String.class);
        if (encoding == null) {
            encoding = this.getConfiguration().getPlainTextEncoding();
        }
        LOG.debug("Messge encoding: {}", (Object)encoding);
        return encoding;
    }

    protected Document parseInput(InputStream is, Boolean disallowDoctypeDecl, Schema schema, ErrorHandler errorHandler) throws ParserConfigurationException, IOException, XmlSignatureFormatException {
        try {
            DocumentBuilder db = XmlSignatureHelper.newDocumentBuilder(disallowDoctypeDecl, schema);
            db.setErrorHandler(errorHandler);
            Document document = db.parse(is);
            return document;
        }
        catch (SAXException e) {
            throw new XmlSignatureFormatException("XML signature generation not possible. Sent message is not an XML document. Check the sent message.", e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)"input stream");
        }
    }

    protected Reference createReference(XMLSignatureFactory fac, String uri, String type, SignatureType sigType, String id) throws InvalidAlgorithmParameterException, XmlSignatureException {
        try {
            List<Transform> transforms = this.getTransforms(fac, sigType);
            Reference ref = fac.newReference(uri, fac.newDigestMethod(this.getDigestAlgorithmUri(), null), transforms, type, id);
            return ref;
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlSignatureException("Wrong algorithm specified in the configuration.", e);
        }
    }

    protected String getContentReferenceType(Message message) {
        String type = (String)message.getHeader("CamelXmlSignatureContentReferenceType", String.class);
        if (type == null) {
            type = this.getConfiguration().getContentReferenceType();
        }
        LOG.debug("Content reference type: {}", (Object)type);
        return type;
    }

    protected List<String> getContentReferenceUris(Message message, SignatureType signatureType, Node messageBodyNode) throws XmlSignatureException, XPathExpressionException {
        List<String> result;
        if (SignatureType.enveloping == signatureType) {
            String uri = "#" + this.getConfiguration().getContentObjectId();
            result = Collections.singletonList(uri);
        } else if (SignatureType.enveloped == signatureType) {
            String uri = (String)message.getHeader("CamelXmlSignatureContentReferenceUri", String.class);
            if (uri == null) {
                uri = this.getConfiguration().getContentReferenceUri();
            }
            if (uri == null) {
                uri = "";
            }
            result = Collections.singletonList(uri);
        } else if (SignatureType.detached == signatureType) {
            result = this.getContentReferenceUrisForDetachedCase(message, messageBodyNode);
        } else {
            throw new IllegalStateException("Signature type " + (Object)((Object)signatureType) + " not supported");
        }
        LOG.debug("Content reference URI(s): {}", result);
        return result;
    }

    private List<String> getContentReferenceUrisForDetachedCase(Message message, Node messageBodyNode) throws XmlSignatureException, XPathExpressionException {
        List<XPathFilterParameterSpec> xpathsToIdAttributes = this.getXpathToIdAttributes(message);
        if (xpathsToIdAttributes.isEmpty()) {
            throw new IllegalStateException("List of XPATHs to ID attributes is empty in detached signature case");
        }
        ArrayList<ComparableNode> result = new ArrayList<ComparableNode>(xpathsToIdAttributes.size());
        for (XPathFilterParameterSpec xp : xpathsToIdAttributes) {
            XPathExpression exp;
            try {
                exp = XmlSignatureHelper.getXPathExpression(xp);
            }
            catch (XPathExpressionException e) {
                throw new XmlSignatureException("The configured xpath expression " + xp.getXPath() + " is invalid.", e);
            }
            NodeList list = (NodeList)exp.evaluate(messageBodyNode, XPathConstants.NODESET);
            if (list == null) {
                LOG.warn("No ID attribute found for xpath expression {}. Therfore this xpath expression will be ignored.", (Object)xp.getXPath());
                continue;
            }
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element element;
                String value;
                Node node = list.item(i);
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    value = attr.getValue();
                    element = messageBodyNode.getOwnerDocument().getElementById(value);
                    if (element == null) {
                        throw new XmlSignatureException("Wrong configured xpath expression for ID attributes: The evaluation of the xpath expression " + xp.getXPath() + " resulted in an attribute which is not of type ID. The attribute value is " + value + ".");
                    }
                } else {
                    throw new XmlSignatureException("Wrong configured xpath expression for ID attributes: The evaluation of the xpath expression " + xp.getXPath() + " returned a node which was not of type Attribute.");
                }
                result.add(new ComparableNode(element, "#" + value));
                LOG.debug("ID attribute with value {} found for xpath {}", (Object)value, (Object)xp.getXPath());
            }
        }
        if (result.size() == 0) {
            throw new XmlSignatureException("No element to sign found in the detached case. No node found for the configured xpath expressions " + this.toString(xpathsToIdAttributes) + ". Either the configuration of the XML signature component is wrong or the incoming message has not the correct structure.");
        }
        Collections.sort(result);
        return ComparableNode.getReferenceUris(result);
    }

    private String toString(List<XPathFilterParameterSpec> xpathsToIdAttributes) {
        StringBuilder result = new StringBuilder();
        int counter = 0;
        for (XPathFilterParameterSpec xp : xpathsToIdAttributes) {
            result.append(xp.getXPath());
            if (++counter >= xpathsToIdAttributes.size()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected XMLObject createXMLObject(XMLSignatureFactory fac, Node node, String id) {
        return fac.newXMLObject(Collections.singletonList(new DOMStructure(node)), id, null, null);
    }

    private List<Transform> getTransforms(XMLSignatureFactory fac, SignatureType sigType) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        List<AlgorithmMethod> configuredTrafos = this.getConfiguration().getTransformMethods();
        if (SignatureType.enveloped == sigType) {
            if (configuredTrafos.size() > 0) {
                if (!this.containsEnvelopedTransform(configuredTrafos)) {
                    configuredTrafos = new ArrayList<AlgorithmMethod>(configuredTrafos.size() + 1);
                    configuredTrafos.add(XmlSignatureHelper.getEnvelopedTransform());
                    configuredTrafos.addAll(this.getConfiguration().getTransformMethods());
                }
            } else {
                configuredTrafos = new ArrayList<AlgorithmMethod>(2);
                configuredTrafos.add(XmlSignatureHelper.getEnvelopedTransform());
                configuredTrafos.add(XmlSignatureHelper.getCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
            }
        }
        ArrayList<Transform> transforms = new ArrayList<Transform>(configuredTrafos.size());
        for (AlgorithmMethod trafo : configuredTrafos) {
            Transform transform = fac.newTransform(trafo.getAlgorithm(), (TransformParameterSpec)trafo.getParameterSpec());
            transforms.add(transform);
            LOG.debug("Transform method: {}", (Object)trafo.getAlgorithm());
        }
        return transforms;
    }

    private boolean containsEnvelopedTransform(List<AlgorithmMethod> configuredTrafos) {
        for (AlgorithmMethod m : configuredTrafos) {
            if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(m.getAlgorithm())) continue;
            return true;
        }
        return false;
    }

    protected String getDigestAlgorithmUri() throws XmlSignatureException {
        String signatureAlgorithm;
        String result = this.getConfiguration().getDigestAlgorithm();
        if (result == null && (signatureAlgorithm = this.getConfiguration().getSignatureAlgorithm()) != null) {
            if (signatureAlgorithm.contains(SHA1)) {
                result = "http://www.w3.org/2000/09/xmldsig#sha1";
            } else if (signatureAlgorithm.contains(SHA224)) {
                result = HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA224;
            } else if (signatureAlgorithm.contains(SHA256)) {
                result = "http://www.w3.org/2001/04/xmlenc#sha256";
            } else if (signatureAlgorithm.contains(SHA384)) {
                result = HTTP_WWW_W3_ORG_2001_04_XMLDSIG_MORE_SHA384;
            } else if (signatureAlgorithm.contains(SHA512)) {
                result = "http://www.w3.org/2001/04/xmlenc#sha512";
            } else if (signatureAlgorithm.contains(RIPEMD160)) {
                return "http://www.w3.org/2001/04/xmlenc#ripemd160";
            }
        }
        if (result != null) {
            LOG.debug("Digest algorithm: {}", (Object)result);
            return result;
        }
        throw new XmlSignatureException("Digest algorithm missing for XML signature generation. Specify the digest algorithm in the configuration.");
    }

    protected Reference createKeyInfoReference(XMLSignatureFactory fac, String keyInfoId, String digestAlgorithm) throws Exception {
        if (keyInfoId == null) {
            return null;
        }
        if (this.getConfiguration().getAddKeyInfoReference() == null) {
            return null;
        }
        if (!this.getConfiguration().getAddKeyInfoReference().booleanValue()) {
            return null;
        }
        LOG.debug("Creating reference to key info element with Id: {}", (Object)keyInfoId);
        ArrayList<Transform> transforms = new ArrayList<Transform>(1);
        Transform transform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        transforms.add(transform);
        return fac.newReference("#" + keyInfoId, fac.newDigestMethod(digestAlgorithm, null), transforms, null, null);
    }

    private String getKeyInfoId(KeyInfo keyInfo) throws Exception {
        if (keyInfo == null) {
            return null;
        }
        return keyInfo.getId();
    }

    protected void setOutputEncodingToMessageHeader(Message message) {
        if (this.getConfiguration().getOutputXmlEncoding() != null) {
            message.setHeader("CamelCharsetName", (Object)this.getConfiguration().getOutputXmlEncoding());
        }
    }

    static class ComparableNode
    implements Comparable<ComparableNode> {
        private final String referenceUri;
        private final int level;

        ComparableNode(Element node, String referenceUri) {
            this.referenceUri = referenceUri;
            this.level = this.calculateLevel(node);
        }

        private int calculateLevel(Element node) {
            int counter = 0;
            for (Node n = node; n != null; n = n.getParentNode()) {
                if (1 != n.getNodeType() || ++counter <= 10000) continue;
                throw new IllegalStateException("Hierachy level is limited to 10000");
            }
            return counter;
        }

        @Override
        public int compareTo(ComparableNode o) {
            return o.level - this.level;
        }

        String getReferenceUri() {
            return this.referenceUri;
        }

        static List<String> getReferenceUris(List<ComparableNode> input) {
            ArrayList<String> result = new ArrayList<String>(input.size());
            for (ComparableNode cn : input) {
                result.add(cn.getReferenceUri());
            }
            return result;
        }
    }

    private static class InputBuilder {
        private XMLSignatureFactory signatureFactory;
        private String signatureAlgorithm;
        private Node parent;
        private Node messageBodyNode;
        private Message message;
        private KeyInfo keyInfo;
        private String contentDigestAlgorithm;
        private String signatureId;
        private String contentReferenceUri;
        private SignatureType signatureType;
        private String prefixForXmlSignatureNamespace;

        private InputBuilder() {
        }

        public InputBuilder signatureFactory(XMLSignatureFactory signatureFactory) {
            this.signatureFactory = signatureFactory;
            return this;
        }

        public InputBuilder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public InputBuilder parent(Node parent) {
            this.parent = parent;
            return this;
        }

        public InputBuilder messageBodyNode(Node messageBodyNode) {
            this.messageBodyNode = messageBodyNode;
            return this;
        }

        public InputBuilder message(Message message) {
            this.message = message;
            return this;
        }

        public InputBuilder keyInfo(KeyInfo keyInfo) {
            this.keyInfo = keyInfo;
            return this;
        }

        public InputBuilder contentDigestAlgorithm(String contentDigestAlgorithm) {
            this.contentDigestAlgorithm = contentDigestAlgorithm;
            return this;
        }

        public InputBuilder signatureId(String signatureId) {
            this.signatureId = signatureId;
            return this;
        }

        public InputBuilder contentReferenceUri(String contentReferenceUri) {
            this.contentReferenceUri = contentReferenceUri;
            return this;
        }

        public InputBuilder signatureType(SignatureType signatureType) {
            this.signatureType = signatureType;
            return this;
        }

        public InputBuilder prefixForXmlSignatureNamespace(String prefixForXmlSignatureNamespace) {
            this.prefixForXmlSignatureNamespace = prefixForXmlSignatureNamespace;
            return this;
        }

        public XmlSignatureProperties.Input build() {
            return new XmlSignatureProperties.Input(){

                @Override
                public XMLSignatureFactory getSignatureFactory() {
                    return InputBuilder.this.signatureFactory;
                }

                @Override
                public String getSignatureAlgorithm() {
                    return InputBuilder.this.signatureAlgorithm;
                }

                @Override
                public Node getParent() {
                    return InputBuilder.this.parent;
                }

                @Override
                public Node getMessageBodyNode() {
                    return InputBuilder.this.messageBodyNode;
                }

                @Override
                public Message getMessage() {
                    return InputBuilder.this.message;
                }

                @Override
                public KeyInfo getKeyInfo() {
                    return InputBuilder.this.keyInfo;
                }

                @Override
                public String getContentDigestAlgorithm() {
                    return InputBuilder.this.contentDigestAlgorithm;
                }

                @Override
                public String getSignatureId() {
                    return InputBuilder.this.signatureId;
                }

                @Override
                public String getContentReferenceUri() {
                    return InputBuilder.this.contentReferenceUri;
                }

                @Override
                public SignatureType getSignatureType() {
                    return InputBuilder.this.signatureType;
                }

                @Override
                public String getPrefixForXmlSignatureNamespace() {
                    return InputBuilder.this.prefixForXmlSignatureNamespace;
                }
            };
        }
    }
}

