/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmlsecurity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XMLSecurityDataFormat
implements DataFormat,
CamelContextAware {
    public static final String XML_ENC_RECIPIENT_ALIAS = "CamelXmlEncryptionRecipientAlias";
    public static final String XML_ENC_TRUST_STORE_URL = "CamelXmlEncryptionTrustStoreUrl";
    public static final String XML_ENC_TRUST_STORE_PASSWORD = "CamelXmlEncryptionTrustStorePassword";
    public static final String XML_ENC_KEY_STORE_URL = "CamelXmlEncryptionKeyStoreUrl";
    public static final String XML_ENC_KEY_STORE_PASSWORD = "CamelXmlEncryptionKeyStorePassword";
    public static final String XML_ENC_KEY_STORE_ALIAS = "CamelXmlEncryptionKeyAlias";
    private String xmlCipherAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private String keyCipherAlgorithm;
    private byte[] passPhrase = "Just another 24 Byte key".getBytes();
    private String secureTag = "";
    private boolean secureTagContents = true;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private String keyStoreAlias;
    private String keyStorePassword;
    private String trustStorePassword;
    private String recipientKeyAlias;
    private CamelContext camelContext;

    public XMLSecurityDataFormat() {
        Init.init();
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase, String xmlCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    public void setCamelContext(CamelContext camelContext) {
        try {
            this.setDefaultsFromContext(camelContext);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize XMLSecurityDataFormat with camelContext. ", e);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    private void setDefaultsFromContext(CamelContext context) throws Exception {
        Map contextProps = context.getProperties();
        if (this.recipientKeyAlias == null) {
            this.recipientKeyAlias = (String)contextProps.get(XML_ENC_RECIPIENT_ALIAS);
        }
        if (this.trustStore == null && contextProps.containsKey(XML_ENC_TRUST_STORE_URL)) {
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            URL trustStoreUrl = new URL((String)contextProps.get(XML_ENC_TRUST_STORE_URL));
            if (this.trustStorePassword == null) {
                this.trustStorePassword = (String)contextProps.get(XML_ENC_TRUST_STORE_PASSWORD);
            }
            this.trustStore.load(trustStoreUrl.openStream(), this.trustStorePassword.toCharArray());
        }
        if (this.keyStore == null && contextProps.containsKey(XML_ENC_KEY_STORE_URL)) {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            URL keyStoreUrl = new URL((String)contextProps.get(XML_ENC_KEY_STORE_URL));
            if (this.keyStorePassword == null) {
                this.keyStorePassword = (String)contextProps.get(XML_ENC_KEY_STORE_PASSWORD);
            }
            this.keyStore.load(keyStoreUrl.openStream(), this.keyStorePassword.toCharArray());
        }
        if (this.keyStoreAlias == null) {
            this.keyStoreAlias = (String)contextProps.get(XML_ENC_KEY_STORE_ALIAS);
        }
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        Document document = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
        if (null != this.keyCipherAlgorithm && (this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"))) {
            this.encryptAsymmetric(exchange, document, stream);
        } else if (null != this.recipientKeyAlias) {
            this.encryptAsymmetric(exchange, document, stream);
        } else {
            this.encryptSymmetric(exchange, document, stream);
        }
    }

    private void encryptAsymmetric(Exchange exchange, Document document, OutputStream stream) throws Exception {
        String exchangeRecipientAlias = this.getRecipientKeyAlias(exchange);
        if (null == exchangeRecipientAlias) {
            throw new IllegalStateException("The  recipient's key alias must be defined for asymmetric key encryption.");
        }
        if (null == this.trustStore) {
            throw new IllegalStateException("A trust store must be defined for asymmetric key encryption.");
        }
        Key keyEncryptionKey = this.getPublicKey(this.trustStore, exchangeRecipientAlias, this.trustStorePassword);
        if (null == keyEncryptionKey) {
            throw new IllegalStateException("No key for the alias [ " + exchangeRecipientAlias + " ] exists in " + "the configured trust store.");
        }
        Key dataEncryptionKey = this.generateDataEncryptionKey();
        XMLCipher keyCipher = null != this.getKeyCyperAlgorithm() ? XMLCipher.getInstance((String)this.getKeyCyperAlgorithm()) : XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        keyCipher.init(3, keyEncryptionKey);
        this.encrypt(exchange, document, stream, dataEncryptionKey, keyCipher);
    }

    private void encryptSymmetric(Exchange exchange, Document document, OutputStream stream) throws Exception {
        Key dataEncryptionKey;
        Key keyEncryptionKey;
        if (this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            keyEncryptionKey = this.generateKeyEncryptionKey("DESede");
            dataEncryptionKey = this.generateDataEncryptionKey();
        } else {
            keyEncryptionKey = this.generateKeyEncryptionKey("AES");
            dataEncryptionKey = this.generateDataEncryptionKey();
        }
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.generateXmlCipherAlgorithmKeyWrap());
        keyCipher.init(3, keyEncryptionKey);
        this.encrypt(exchange, document, stream, dataEncryptionKey, keyCipher);
    }

    private Key getPrivateKey(KeyStore keystore, String alias, String password) throws Exception {
        Key key = keystore.getKey(alias, password.toCharArray());
        if (key instanceof PrivateKey) {
            return key;
        }
        return null;
    }

    private Key getPublicKey(KeyStore keystore, String alias, String password) throws Exception {
        Key key = keystore.getKey(alias, password.toCharArray());
        if (key instanceof PublicKey) {
            return key;
        }
        Certificate cert = keystore.getCertificate(alias);
        PublicKey publicKey = cert.getPublicKey();
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encrypt(Exchange exchange, Document document, OutputStream stream, Key dataEncryptionKey, XMLCipher keyCipher) throws Exception {
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.xmlCipherAlgorithm);
        xmlCipher.init(1, dataEncryptionKey);
        if (this.secureTag.equalsIgnoreCase("")) {
            this.embedKeyInfoInEncryptedData(document, keyCipher, xmlCipher, dataEncryptionKey);
            document = xmlCipher.doFinal(document, document.getDocumentElement());
        } else {
            Node node;
            NodeIterator iter = XPathAPI.selectNodeIterator((Node)document, (String)this.secureTag);
            while ((node = iter.nextNode()) != null) {
                this.embedKeyInfoInEncryptedData(document, keyCipher, xmlCipher, dataEncryptionKey);
                Document temp = xmlCipher.doFinal(document, (Element)node, this.getSecureTagContents());
                document.importNode(temp.getDocumentElement().cloneNode(true), true);
            }
        }
        try {
            DOMSource source = new DOMSource(document);
            InputStream sis = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)source);
            IOHelper.copy((InputStream)sis, (OutputStream)stream);
        }
        finally {
            stream.close();
        }
    }

    public Object unmarshal(Exchange exchange, Document document) throws Exception {
        InputStream is = (InputStream)ExchangeHelper.getMandatoryInBody((Exchange)exchange, InputStream.class);
        return this.unmarshal(exchange, is);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Document encodedDocument = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)stream);
        if (null != this.keyCipherAlgorithm && (this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"))) {
            return this.decodeWithAsymmetricKey(exchange, encodedDocument);
        }
        return this.decodeWithSymmetricKey(exchange, encodedDocument);
    }

    private Object decodeWithSymmetricKey(Exchange exchange, Document encodedDocument) throws Exception {
        Key keyEncryptionKey = this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") ? this.generateKeyEncryptionKey("DESede") : this.generateKeyEncryptionKey("AES");
        return this.decode(exchange, encodedDocument, keyEncryptionKey);
    }

    private Object decodeWithAsymmetricKey(Exchange exchange, Document encodedDocument) throws Exception {
        if (this.keyStore == null) {
            throw new IllegalStateException("A key store must be defined for asymmetric key decryption.");
        }
        Key keyEncryptionKey = this.getPrivateKey(this.keyStore, this.keyStoreAlias, this.keyStorePassword);
        return this.decode(exchange, encodedDocument, keyEncryptionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decode(Exchange exchange, Document encodedDocument, Key keyEncryptionKey) throws Exception {
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        xmlCipher.setKEK(keyEncryptionKey);
        if (this.secureTag.equalsIgnoreCase("")) {
            encodedDocument = xmlCipher.doFinal(encodedDocument, encodedDocument.getDocumentElement());
        } else {
            Node node;
            NodeIterator iter = XPathAPI.selectNodeIterator((Node)encodedDocument, (String)this.secureTag);
            while ((node = iter.nextNode()) != null) {
                if (this.getSecureTagContents()) {
                    Document temp = xmlCipher.doFinal(encodedDocument, (Element)node, true);
                    encodedDocument.importNode(temp.getDocumentElement().cloneNode(true), true);
                    continue;
                }
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (!childNode.getLocalName().equals("EncryptedData")) continue;
                    Document temp = xmlCipher.doFinal(encodedDocument, (Element)childNode, false);
                    encodedDocument.importNode(temp.getDocumentElement().cloneNode(true), true);
                }
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DOMSource source = new DOMSource(encodedDocument);
            InputStream sis = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)source);
            IOHelper.copy((InputStream)sis, (OutputStream)bos);
        }
        finally {
            bos.close();
        }
        return bos.toByteArray();
    }

    private Key generateKeyEncryptionKey(String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKey secretKey;
        try {
            if (algorithm.equalsIgnoreCase("DESede")) {
                DESedeKeySpec keySpec = new DESedeKeySpec(this.passPhrase);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                secretKey = keyFactory.generateSecret(keySpec);
            } else {
                secretKey = new SecretKeySpec(this.passPhrase, "AES");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("InvalidKeyException due to invalid passPhrase: " + Arrays.toString(this.passPhrase));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("NoSuchAlgorithmException while using XMLCipher.TRIPLEDES algorithm: DESede");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("Invalid Key generated while using passPhrase: " + Arrays.toString(this.passPhrase));
        }
        return secretKey;
    }

    private Key generateDataEncryptionKey() throws Exception {
        KeyGenerator keyGenerator = null;
        keyGenerator = this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") ? KeyGenerator.getInstance("DESede") : KeyGenerator.getInstance("AES");
        if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            keyGenerator.init(128);
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            keyGenerator.init(192);
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            keyGenerator.init(256);
        }
        return keyGenerator.generateKey();
    }

    private void embedKeyInfoInEncryptedData(Document document, XMLCipher keyCipher, XMLCipher xmlCipher, Key dataEncryptionkey) throws XMLEncryptionException {
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, dataEncryptionkey);
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
        encryptedDataElement.setKeyInfo(keyInfo);
    }

    private String generateXmlCipherAlgorithmKeyWrap() {
        String algorithmKeyWrap = null;
        if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }
        return algorithmKeyWrap;
    }

    private String getRecipientKeyAlias(Exchange exchange) {
        String alias = (String)exchange.getIn().getHeader(XML_ENC_RECIPIENT_ALIAS, String.class);
        if (alias != null) {
            exchange.getIn().setHeader(XML_ENC_RECIPIENT_ALIAS, null);
        } else {
            alias = this.recipientKeyAlias;
        }
        return alias;
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public String getKeyCyperAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public void setKeyCipherAlgorithm(String keyCipherAlgorithm) {
        this.keyCipherAlgorithm = keyCipherAlgorithm;
    }

    public String getRecipientKeyAlias() {
        return this.recipientKeyAlias;
    }

    public void setRecipientKeyAlias(String recipientKeyAlias) {
        this.recipientKeyAlias = recipientKeyAlias;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents;
    }

    public boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStorePassowrd() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }
}

