/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.Iterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.component.xmpp.XmppExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.RosterPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppConsumer
extends DefaultConsumer<XmppExchange>
implements PacketListener {
    private static final transient Log LOG = LogFactory.getLog(XmppConsumer.class);
    private final XmppEndpoint endpoint;

    public XmppConsumer(XmppEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.getConnection().addPacketListener((PacketListener)this, this.endpoint.getFilter());
    }

    protected void doStop() throws Exception {
        this.endpoint.getConnection().removePacketListener((PacketListener)this);
        super.doStop();
    }

    public void processPacket(Packet packet) {
        if (packet instanceof Message) {
            Message message = (Message)packet;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<<<< message: " + message.getBody()));
            }
            XmppExchange exchange = this.endpoint.createExchange(message);
            try {
                this.getProcessor().process((Exchange)exchange);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (packet instanceof RosterPacket) {
            RosterPacket rosterPacket = (RosterPacket)packet;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Roster packet with : " + rosterPacket.getRosterItemCount() + " item(s)"));
                Iterator rosterItems = rosterPacket.getRosterItems();
                while (rosterItems.hasNext()) {
                    Object item = rosterItems.next();
                    LOG.debug((Object)("Roster item: " + item));
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<<<< ignored packet: " + packet));
        }
    }
}

