/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.RuntimeXmppException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class XmppGroupChatProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(XmppGroupChatProducer.class);
    private final XmppEndpoint endpoint;
    private final String room;
    private MultiUserChat chat;

    public XmppGroupChatProducer(XmppEndpoint endpoint) throws XMPPException, CamelException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.room = endpoint.resolveRoom();
        if (this.room == null) {
            throw new IllegalArgumentException("No room property specified");
        }
    }

    public void process(Exchange exchange) {
        Message message = this.chat.createMessage();
        message.setTo(this.room);
        message.setFrom(this.endpoint.getUser());
        this.endpoint.getBinding().populateXmppMessage(message, exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending XMPP message: " + message.getBody()));
        }
        try {
            this.chat.sendMessage(message);
        }
        catch (XMPPException e) {
            throw new RuntimeXmppException(e);
        }
    }

    protected void doStart() throws Exception {
        if (this.chat == null) {
            this.chat = new MultiUserChat(this.endpoint.getConnection(), this.room);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.chat.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.chat != null) {
            this.chat.leave();
            this.chat = null;
        }
        super.doStop();
    }

    public MultiUserChat getChat() {
        return this.chat;
    }

    public void setChat(MultiUserChat chat) {
        this.chat = chat;
    }

    public String getRoom() {
        return this.room;
    }
}

