/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppComponent
extends DefaultComponent {
    private static final transient Log LOG = LogFactory.getLog(XmppComponent.class);
    Map<String, XmppEndpoint> endpointCache = new HashMap<String, XmppEndpoint>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String remainingPath;
        if (this.endpointCache.containsKey(uri)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using cached endpoint for URI " + uri));
            }
            return (Endpoint)this.endpointCache.get(uri);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating new endpoint for URI " + uri));
        }
        XmppEndpoint endpoint = new XmppEndpoint(uri, this);
        URI u = new URI(uri);
        endpoint.setHost(u.getHost());
        endpoint.setPort(u.getPort());
        if (u.getUserInfo() != null) {
            endpoint.setUser(u.getUserInfo());
        }
        if ((remainingPath = u.getPath()) != null) {
            if (remainingPath.startsWith("/")) {
                remainingPath = remainingPath.substring(1);
            }
            if (remainingPath.length() > 0) {
                endpoint.setParticipant(remainingPath);
            }
        }
        this.endpointCache.put(uri, endpoint);
        return endpoint;
    }

    protected synchronized void doStop() throws Exception {
        for (Map.Entry<String, XmppEndpoint> entry : this.endpointCache.entrySet()) {
            entry.getValue().destroy();
        }
        this.endpointCache.clear();
    }
}

