/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmpp.XmppBinding;
import org.apache.camel.component.xmpp.XmppComponent;
import org.apache.camel.component.xmpp.XmppConsumer;
import org.apache.camel.component.xmpp.XmppGroupChatProducer;
import org.apache.camel.component.xmpp.XmppLogger;
import org.apache.camel.component.xmpp.XmppMessage;
import org.apache.camel.component.xmpp.XmppPrivateChatProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppEndpoint.class);
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
    private XmppBinding binding;
    private String host;
    private int port;
    private String user;
    private String password;
    private String resource = "Camel";
    private boolean login = true;
    private boolean createAccount;
    private String room;
    private String participant;
    private String nickname;
    private String serviceName;
    private XMPPConnection connection;

    public XmppEndpoint() {
    }

    public XmppEndpoint(String uri, XmppComponent component) {
        super(uri, (Component)component);
    }

    public XmppEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        if (this.room != null) {
            return this.createGroupChatProducer();
        }
        if (this.getParticipant() == null) {
            throw new IllegalArgumentException("No room or participant configured on this endpoint: " + (Object)((Object)this));
        }
        return this.createPrivateChatProducer(this.getParticipant());
    }

    public Producer createGroupChatProducer() throws Exception {
        return new XmppGroupChatProducer(this);
    }

    public Producer createPrivateChatProducer(String participant) throws Exception {
        return new XmppPrivateChatProducer(this, participant);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new XmppConsumer(this, processor);
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.createExchange(pattern, null);
    }

    public Exchange createExchange(org.jivesoftware.smack.packet.Message message) {
        return this.createExchange(this.getExchangePattern(), message);
    }

    private Exchange createExchange(ExchangePattern pattern, org.jivesoftware.smack.packet.Message message) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)new XmppMessage(message));
        return exchange;
    }

    protected String createEndpointUri() {
        return "xmpp://" + this.host + ":" + this.port + "/" + this.getParticipant() + "?serviceName=" + this.serviceName;
    }

    public boolean isSingleton() {
        return true;
    }

    public XMPPConnection createConnection() throws XMPPException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = this.port > 0 ? (this.getServiceName() == null ? new XMPPConnection(new ConnectionConfiguration(this.host, this.port)) : new XMPPConnection(new ConnectionConfiguration(this.host, this.port, this.serviceName))) : new XMPPConnection(this.host);
        this.connection.connect();
        this.connection.addPacketListener((PacketListener)new XmppLogger("INBOUND"), new PacketFilter(){

            public boolean accept(Packet packet) {
                return true;
            }
        });
        this.connection.addPacketWriterListener((PacketListener)new XmppLogger("OUTBOUND"), new PacketFilter(){

            public boolean accept(Packet packet) {
                return true;
            }
        });
        if (!this.connection.isAuthenticated()) {
            if (this.user != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Logging in to XMPP as user: " + this.user + " on connection: " + XmppEndpoint.getConnectionMessage(this.connection));
                }
                if (this.password == null) {
                    LOG.warn("No password configured for user: " + this.user + " on connection: " + XmppEndpoint.getConnectionMessage(this.connection));
                }
                if (this.createAccount) {
                    AccountManager accountManager = new AccountManager(this.connection);
                    accountManager.createAccount(this.user, this.password);
                }
                if (this.login) {
                    if (this.resource != null) {
                        this.connection.login(this.user, this.password, this.resource);
                    } else {
                        this.connection.login(this.user, this.password);
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Logging in anonymously to XMPP on connection: " + XmppEndpoint.getConnectionMessage(this.connection));
                }
                this.connection.loginAnonymously();
            }
        }
        return this.connection;
    }

    public String resolveRoom(XMPPConnection connection) throws XMPPException {
        ObjectHelper.notEmpty((String)this.room, (String)"room");
        if (this.room.indexOf(64, 0) != -1) {
            return this.room;
        }
        Iterator iterator = MultiUserChat.getServiceNames((XMPPConnection)connection).iterator();
        if (!iterator.hasNext()) {
            throw new XMPPException("Cannot find Multi User Chat service on connection: " + XmppEndpoint.getConnectionMessage(connection));
        }
        String chatServer = (String)iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected chat server: " + chatServer);
        }
        return this.room + "@" + chatServer;
    }

    public static String getConnectionMessage(XMPPConnection connection) {
        return connection.getHost() + ":" + connection.getPort() + "/" + connection.getServiceName();
    }

    public String getChatId() {
        return "Chat:" + this.getParticipant() + ":" + this.getUser();
    }

    public XmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new XmppBinding(this.headerFilterStrategy);
        }
        return this.binding;
    }

    public void setBinding(XmppBinding binding) {
        this.binding = binding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getParticipant() {
        return this.participant != null ? this.participant : this.user;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public String getNickname() {
        return this.nickname != null ? this.nickname : this.getUser();
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = null;
        this.binding = null;
    }
}

