/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmppGroupChatProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(XmppGroupChatProducer.class);
    private final XmppEndpoint endpoint;
    private XMPPConnection connection;
    private MultiUserChat chat;
    private String room;

    public XmppGroupChatProducer(XmppEndpoint endpoint) throws XMPPException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        Message message = this.chat.createMessage();
        message.setTo(this.room);
        message.setFrom(this.endpoint.getUser());
        this.endpoint.getBinding().populateXmppMessage(message, exchange);
        try {
            if (!this.connection.isConnected()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reconnecting to: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
                }
                this.connection.connect();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending XMPP message: {}", (Object)message.getBody());
            }
            this.chat.sendMessage(message);
            this.chat.pollMessage();
        }
        catch (XMPPException e) {
            throw new RuntimeExchangeException("Cannot send XMPP message: " + message, exchange, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (this.connection == null) {
            this.connection = this.endpoint.createConnection();
        }
        if (this.chat == null) {
            this.room = this.endpoint.resolveRoom(this.connection);
            this.chat = new MultiUserChat(this.connection, this.room);
            DiscussionHistory history = new DiscussionHistory();
            history.setMaxChars(0);
            this.chat.join(this.endpoint.getNickname(), null, history, (long)SmackConfiguration.getPacketReplyTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info("Joined room: {} as: {}", (Object)this.room, (Object)this.endpoint.getNickname());
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.chat != null) {
            LOG.info("Leaving room: {}", (Object)this.room);
            this.chat.leave();
        }
        this.chat = null;
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.connection = null;
        super.doStop();
    }

    public String getRoom() {
        return this.room;
    }
}

