/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.Comparator;

public class NaturalSortComparator
implements Comparator<CharSequence> {
    private Order order;

    public NaturalSortComparator() {
        this(Order.Ascending);
    }

    public NaturalSortComparator(Order order) {
        if (order != null) {
            this.order = order;
        }
    }

    @Override
    public int compare(CharSequence first, CharSequence second) {
        if (first == null && second == null) {
            return 0;
        }
        if (first != null && second == null) {
            return 1;
        }
        if (first == null && second != null) {
            return -1;
        }
        int compare = 0;
        int fx = 0;
        for (int sx = 0; fx < first.length() && sx < second.length() && compare == 0; ++fx, ++sx) {
            if (this.isDigit(first.charAt(fx)) && this.isDigit(second.charAt(sx))) {
                int slen;
                int flen = this.getNumSequenceLength(first, fx);
                if (flen == (slen = this.getNumSequenceLength(second, sx))) {
                    for (int x = 0; x < flen && compare == 0; ++x) {
                        compare = first.charAt(fx++) - second.charAt(sx++);
                    }
                    continue;
                }
                compare = flen - slen;
                continue;
            }
            compare = first.charAt(fx) - second.charAt(sx);
        }
        if (compare == 0) {
            compare = first.length() - second.length();
        }
        return this.order.direction * compare;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c < '9';
    }

    private int getNumSequenceLength(CharSequence sequence, int index) {
        int x;
        for (x = index; x < sequence.length() && this.isDigit(sequence.charAt(x)); ++x) {
        }
        return x - index;
    }

    public static enum Order {
        Ascending(1),
        Descending(-1);

        int direction;

        private Order(int direction) {
            this.direction = direction;
        }
    }
}

