/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.exec.AbstractExecMojo;

public class EmbeddedMojo
extends AbstractExecMojo {
    protected String duration;
    protected String outputDirectory;
    protected boolean dotEnabled;
    protected boolean dotAggregationEnabled;
    private List classpathElements;
    private String mainClass;

    public void execute() throws MojoExecutionException {
        try {
            this.executeWithoutWrapping();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithoutWrapping() throws MalformedURLException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, MojoExecutionException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newLoader = this.createClassLoader(null);
            Thread.currentThread().setContextClassLoader(newLoader);
            this.runCamel(newLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String inOutputDirectory) {
        this.outputDirectory = inOutputDirectory;
    }

    public List getClasspathElements() {
        return this.classpathElements;
    }

    public void setClasspathElements(List classpathElements) {
        this.classpathElements = classpathElements;
    }

    public boolean isDotEnabled() {
        return this.dotEnabled;
    }

    public void setDotEnabled(boolean dotEnabled) {
        this.dotEnabled = dotEnabled;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public boolean isDotAggregationEnabled() {
        return this.dotAggregationEnabled;
    }

    public void setDotAggregationEnabled(boolean dotAggregationEnabled) {
        this.dotAggregationEnabled = dotAggregationEnabled;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    protected void runCamel(ClassLoader newLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Running Camel in: " + newLoader));
        Class<?> type = newLoader.loadClass(this.mainClass);
        Method method = type.getMethod("main", String[].class);
        String[] arguments = this.createArguments();
        this.getLog().debug((CharSequence)("Starting the Camel Main with arguments: " + Arrays.asList(arguments)));
        try {
            method.invoke(null, new Object[]{arguments});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new MojoExecutionException("Failed: " + t, t);
        }
    }

    protected String[] createArguments() {
        ArrayList<String> args = new ArrayList<String>(5);
        if (this.isDotEnabled()) {
            args.add("-outdir");
            args.add(this.getOutputDirectory());
        }
        if (this.isDotAggregationEnabled()) {
            args.add("-aggregate-dot");
            args.add("true");
        }
        args.add("-duration");
        args.add(this.getDuration());
        return args.toArray(new String[0]);
    }

    public ClassLoader createClassLoader(ClassLoader parent) throws MalformedURLException {
        this.getLog().debug((CharSequence)("Using classpath: " + this.classpathElements));
        int size = this.classpathElements.size();
        URL[] urls = new URL[size];
        for (int i = 0; i < size; ++i) {
            String name = (String)this.classpathElements.get(i);
            File file = new File(name);
            urls[i] = file.toURL();
            this.getLog().debug((CharSequence)("URL: " + urls[i]));
        }
        URLClassLoader loader = new URLClassLoader(urls, parent);
        return loader;
    }
}

