/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.karaf.commands.internal.RegexUtil;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="route-start", description="Start a Camel route or a group of routes")
public class RouteStart
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID or a wildcard expression", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        List<Route> camelRoutes = this.camelController.getRoutes(this.context, RegexUtil.wildcardAsRegex(this.route));
        if (camelRoutes == null || camelRoutes.isEmpty()) {
            System.err.println("Camel routes using " + this.route + " not found.");
            return null;
        }
        for (Route camelRoute : camelRoutes) {
            CamelContext camelContext = camelRoute.getRouteContext().getCamelContext();
            camelContext.startRoute(camelRoute.getId());
        }
        return null;
    }
}

