/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.spi.ManagementAgent;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.StringEscapeUtils;

@Command(scope="camel", name="context-info", description="Display detailed information about a Camel context.")
public class ContextInfo
extends OsgiCommandSupport {
    @Argument(index=0, name="name", description="The name of the Camel context", required=true, multiValued=false)
    String name;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        CamelContext camelContext = this.camelController.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found.");
            return null;
        }
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1m\u001b[33mCamel Context " + this.name + "\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tName: " + camelContext.getName()));
        System.out.println(StringEscapeUtils.unescapeJava("\tVersion: " + camelContext.getVersion()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStatus: " + camelContext.getStatus()));
        System.out.println(StringEscapeUtils.unescapeJava("\tUptime: " + camelContext.getUptime()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mStatistics\u001b[0m"));
        ObjectName contextMBean = null;
        ManagementAgent agent = camelContext.getManagementStrategy().getManagementAgent();
        if (agent != null) {
            MBeanServer mBeanServer = agent.getMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("org.apache.camel:type=context,name=\"" + this.name + "\",*"), null);
            Iterator<ObjectName> iterator = set.iterator();
            if (iterator.hasNext()) {
                contextMBean = iterator.next();
            }
            if (mBeanServer.isRegistered(contextMBean)) {
                Long exchangesTotal = (Long)mBeanServer.getAttribute(contextMBean, "ExchangesTotal");
                System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Total: " + exchangesTotal));
                Long exchangesCompleted = (Long)mBeanServer.getAttribute(contextMBean, "ExchangesCompleted");
                System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Completed: " + exchangesCompleted));
                Long exchangesFailed = (Long)mBeanServer.getAttribute(contextMBean, "ExchangesFailed");
                System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Failed: " + exchangesFailed));
                Long minProcessingTime = (Long)mBeanServer.getAttribute(contextMBean, "MinProcessingTime");
                System.out.println(StringEscapeUtils.unescapeJava("\tMin Processing Time: " + minProcessingTime + "ms"));
                Long maxProcessingTime = (Long)mBeanServer.getAttribute(contextMBean, "MaxProcessingTime");
                System.out.println(StringEscapeUtils.unescapeJava("\tMax Processing Time: " + maxProcessingTime + "ms"));
                Long meanProcessingTime = (Long)mBeanServer.getAttribute(contextMBean, "MeanProcessingTime");
                System.out.println(StringEscapeUtils.unescapeJava("\tMean Processing Time: " + meanProcessingTime + "ms"));
                Long totalProcessingTime = (Long)mBeanServer.getAttribute(contextMBean, "TotalProcessingTime");
                System.out.println(StringEscapeUtils.unescapeJava("\tTotal Processing Time: " + totalProcessingTime + "ms"));
                Long lastProcessingTime = (Long)mBeanServer.getAttribute(contextMBean, "LastProcessingTime");
                System.out.println(StringEscapeUtils.unescapeJava("\tLast Processing Time: " + lastProcessingTime + "ms"));
                String load01 = (String)mBeanServer.getAttribute(contextMBean, "Load01");
                String load05 = (String)mBeanServer.getAttribute(contextMBean, "Load05");
                String load15 = (String)mBeanServer.getAttribute(contextMBean, "Load15");
                System.out.println(StringEscapeUtils.unescapeJava("\tLoad Avg: " + load01 + ", " + load05 + ", " + load15));
                Object firstExchangeTimestampObj = mBeanServer.getAttribute(contextMBean, "FirstExchangeCompletedTimestamp");
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (firstExchangeTimestampObj == null) {
                    System.out.println(StringEscapeUtils.unescapeJava("\tFirst Exchange Date:"));
                } else {
                    Date firstExchangeTimestamp = (Date)firstExchangeTimestampObj;
                    System.out.println(StringEscapeUtils.unescapeJava("\tFirst Exchange Date: " + format.format(firstExchangeTimestamp)));
                }
                Object lastExchangeCompletedTimestampObj = mBeanServer.getAttribute(contextMBean, "LastExchangeCompletedTimestamp");
                if (lastExchangeCompletedTimestampObj == null) {
                    System.out.println(StringEscapeUtils.unescapeJava("\tLast Exchange Completed Date:"));
                } else {
                    Date lastExchangeCompletedTimestamp = (Date)lastExchangeCompletedTimestampObj;
                    System.out.println(StringEscapeUtils.unescapeJava("\tLast Exchange Completed Date: " + format.format(lastExchangeCompletedTimestamp)));
                }
                long activeRoutes = 0L;
                long inactiveRoutes = 0L;
                List routeList = camelContext.getRoutes();
                for (Route route : routeList) {
                    if (camelContext.getRouteStatus(route.getId()).isStarted()) {
                        ++activeRoutes;
                        continue;
                    }
                    ++inactiveRoutes;
                }
                System.out.println(StringEscapeUtils.unescapeJava("\tNumber of running routes: " + activeRoutes));
                System.out.println(StringEscapeUtils.unescapeJava("\tNumber of not running routes: " + inactiveRoutes));
            }
        } else {
            System.out.println("");
            System.out.println(StringEscapeUtils.unescapeJava("\u001b[31mJMX Agent of Camel is not reachable. Maybe it has been disabled on the Camel context"));
            System.out.println(StringEscapeUtils.unescapeJava("In consequence, some statistics are not available.\u001b[0m"));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mAdvanced\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tAuto Startup: " + camelContext.isAutoStartup()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStarting Routes: " + camelContext.isStartingRoutes()));
        System.out.println(StringEscapeUtils.unescapeJava("\tSuspended: " + camelContext.isSuspended()));
        System.out.println(StringEscapeUtils.unescapeJava("\tTracing: " + camelContext.isTracing()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mProperties\u001b[0m"));
        for (String property : camelContext.getProperties().keySet()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + property + " = " + (String)camelContext.getProperties().get(property)));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mComponents\u001b[0m"));
        for (String component : camelContext.getComponentNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + component));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mEndpoints\u001b[0m"));
        for (Endpoint endpoint : camelContext.getEndpoints()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + endpoint.getEndpointUri()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mRoutes\u001b[0m"));
        for (Route route : camelContext.getRoutes()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + route.getId()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mUsed Languages\u001b[0m"));
        for (String language : camelContext.getLanguageNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + language));
        }
        return null;
    }
}

