/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.util.URISupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="endpoint-list", description="Lists all Camel endpoints available in CamelContexts.")
public class EndpointList
extends OsgiCommandSupport {
    private static final String CONTEXT_COLUMN_LABEL = "Context";
    private static final String URI_COLUMN_LABEL = "Uri";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    @Argument(index=0, name="name", description="The Camel context name where to look for the endpoints", required=false, multiValued=false)
    String name;
    @Option(name="--decode", aliases={"-d"}, description="Whether to decode the endpoint uri so its human readable", required=false, multiValued=false, valueToShowInHelp="true")
    Boolean decode;
    @Option(name="--verbose", aliases={"-v"}, description="Verbose output which does not limit the length of the uri shown", required=false, multiValued=false, valueToShowInHelp="false")
    Boolean verbose;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        List<Endpoint> endpoints = this.camelController.getEndpoints(this.name);
        Map<String, Integer> columnWidths = this.computeColumnWidths(endpoints);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        PrintStream out = System.out;
        if (endpoints.size() > 0) {
            out.println(String.format(headerFormat, CONTEXT_COLUMN_LABEL, URI_COLUMN_LABEL, STATUS_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-------", "---", "------"));
            for (Endpoint endpoint : endpoints) {
                String contextId = endpoint.getCamelContext().getName();
                String uri = endpoint.getEndpointUri();
                if (this.decode == null || this.decode.booleanValue()) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                String state = EndpointList.getEndpointState(endpoint);
                out.println(String.format(rowFormat, contextId, uri, state));
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Iterable<Endpoint> endpoints) throws Exception {
        if (endpoints == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<Endpoint>");
        }
        int maxContextLen = 0;
        int maxUriLen = 0;
        int maxStatusLen = 0;
        for (Endpoint endpoint : endpoints) {
            String name = endpoint.getCamelContext().getName();
            maxContextLen = Math.max(maxContextLen, name == null ? 0 : name.length());
            String uri = endpoint.getEndpointUri();
            if (this.decode == null || this.decode.booleanValue()) {
                uri = URLDecoder.decode(uri, "UTF-8");
            }
            maxUriLen = Math.max(maxUriLen, (uri = URISupport.sanitizeUri((String)uri)) == null ? 0 : uri.length());
            String status = EndpointList.getEndpointState(endpoint);
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(CONTEXT_COLUMN_LABEL, maxContextLen);
        retval.put(URI_COLUMN_LABEL, maxUriLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int contextLen = Math.min(columnWidths.get(CONTEXT_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int uriLen = Math.min(columnWidths.get(URI_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        contextLen = Math.max(12, contextLen);
        uriLen = Math.max(12, uriLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(contextLen).append('.').append(contextLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uriLen).append('.').append(uriLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose != null && this.verbose.booleanValue()) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }

    private static String getEndpointState(Endpoint endpoint) {
        if (endpoint instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)endpoint).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }
}

