/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.karaf.commands.internal.RegexUtil;
import org.apache.camel.util.CamelContextHelper;
import org.apache.felix.gogo.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;

public abstract class AbstractRouteCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID or a wildcard expression", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public abstract void executeOnRoute(CamelContext var1, Route var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecute() throws Exception {
        List<Route> camelRoutes = this.camelController.getRoutes(this.context, RegexUtil.wildcardAsRegex(this.route));
        if (camelRoutes == null || camelRoutes.isEmpty()) {
            System.err.println("Camel routes using " + this.route + " not found.");
            return null;
        }
        Collections.sort(camelRoutes, new RouteComparator());
        for (Route camelRoute : camelRoutes) {
            CamelContext camelContext = camelRoute.getRouteContext().getCamelContext();
            ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(camelContext.getApplicationContextClassLoader());
            try {
                this.executeOnRoute(camelContext, camelRoute);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassloader);
            }
        }
        return null;
    }

    private static final class RouteComparator
    implements Comparator<Route> {
        private RouteComparator() {
        }

        @Override
        public int compare(Route route1, Route route2) {
            CamelContext camel1 = route1.getRouteContext().getCamelContext();
            CamelContext camel2 = route2.getRouteContext().getCamelContext();
            if (camel1.getName().equals(camel2.getName())) {
                Integer order1 = CamelContextHelper.getRouteStartupOrder((CamelContext)camel1, (String)route1.getId());
                Integer order2 = CamelContextHelper.getRouteStartupOrder((CamelContext)camel2, (String)route2.getId());
                if (order1 == 0 && order2 == 0) {
                    return route1.getId().compareTo(route2.getId());
                }
                return order1.compareTo(order2);
            }
            return camel1.getName().compareTo(camel2.getName());
        }
    }
}

