/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.StringEscapeUtils;

@Command(scope="camel", name="info-context", description="Display detailed information about a Camel context.")
public class InfoContextCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="name", description="The name of the Camel context", required=true, multiValued=false)
    String name;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        CamelContext camelContext = this.camelController.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found.");
            return null;
        }
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1m\u001b[33mCamel Context " + this.name + "\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tName: " + camelContext.getName()));
        System.out.println(StringEscapeUtils.unescapeJava("\tVersion: " + camelContext.getVersion()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStatus: " + camelContext.getStatus()));
        System.out.println(StringEscapeUtils.unescapeJava("\tUptime: " + camelContext.getUptime()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mAdvanced\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tAuto Startup: " + camelContext.isAutoStartup()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStarting Routes: " + camelContext.isStartingRoutes()));
        System.out.println(StringEscapeUtils.unescapeJava("\tSuspended: " + camelContext.isSuspended()));
        System.out.println(StringEscapeUtils.unescapeJava("\tTracing: " + camelContext.isTracing()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mProperties\u001b[0m"));
        for (String property : camelContext.getProperties().keySet()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + property + " = " + (String)camelContext.getProperties().get(property)));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mComponents\u001b[0m"));
        for (String component : camelContext.getComponentNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + component));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mEndpoints\u001b[0m"));
        for (Endpoint endpoint : camelContext.getEndpoints()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + endpoint.getEndpointUri()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mRoutes\u001b[0m"));
        for (Route route : camelContext.getRoutes()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + route.getId()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mUsed Languages\u001b[0m"));
        for (String language : camelContext.getLanguageNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + language));
        }
        return null;
    }
}

