/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="list-routes", description="List all Camel routes.")
public class ListRoutesCommand
extends OsgiCommandSupport {
    protected static final String OUTPUT_FORMAT = "[%-20s]";
    @Argument(index=0, name="name", description="The Camel context name where to look for the route", required=false, multiValued=false)
    String name;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        List<Route> routes = this.camelController.getRoutes(this.name);
        for (Route route : routes) {
            System.out.println(String.format(OUTPUT_FORMAT, route.getId()));
        }
        return null;
    }
}

