/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ModelHelper;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="show-route", description="Display the Camel route definition in XML.")
public class ShowRouteCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID.", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        Route camelRoute = this.camelController.getRoute(this.route, this.context);
        if (camelRoute == null) {
            System.err.println("Camel route " + this.route + " not found.");
            return null;
        }
        RouteDefinition routeDefinition = this.camelController.getRouteDefinition(this.route, camelRoute.getRouteContext().getCamelContext().getName());
        if (routeDefinition == null) {
            System.err.println("Definition of route " + this.route + " not found.");
            return null;
        }
        System.out.println(ModelHelper.dumpModelAsXml((OptionalIdentifiedDefinition)routeDefinition));
        return null;
    }
}

