/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="context-list", description="Lists all Camel contexts.")
public class ContextList
extends OsgiCommandSupport {
    protected static final String HEADER_FORMAT = "%-20s %-20s %-20s";
    protected static final String OUTPUT_FORMAT = "[%-18s] [%-18s] [%-18s]";
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        System.out.println(String.format(HEADER_FORMAT, "Name", "Status", "Uptime"));
        List<CamelContext> camelContexts = this.camelController.getCamelContexts();
        for (CamelContext camelContext : camelContexts) {
            System.out.println(String.format(OUTPUT_FORMAT, camelContext.getName(), camelContext.getStatus(), camelContext.getUptime()));
        }
        return null;
    }
}

