/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.RouteDefinition;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="route-start", description="Start a Camel route.")
public class RouteStart
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID.", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        Route camelRoute = this.camelController.getRoute(this.route, this.context);
        if (camelRoute == null) {
            List<CamelContext> camelContexts = this.camelController.getCamelContexts();
            for (CamelContext camelContext : camelContexts) {
                RouteDefinition routeDefinition = camelContext.getRouteDefinition(this.route);
                if (routeDefinition == null) continue;
                camelContext.startRoute(routeDefinition.getId());
                return null;
            }
            System.err.println("Camel route " + this.route + " not found.");
            return null;
        }
        CamelContext camelContext = camelRoute.getRouteContext().getCamelContext();
        camelContext.startRoute(this.route);
        return null;
    }
}

