/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.camel.impl.converter.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReportingTypeConverterLoader;
import org.apache.camel.util.ReportingTypeConverterRegistry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class ConvertersMojo
extends AbstractMojo {
    private static final String LINE_SEPARATOR = "-------------------------------------------------------------------------------\n";
    private File reportsDirectory;
    private boolean generateReports;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Camel report directory: " + this.reportsDirectory));
        ReportingTypeConverterLoader loader = new ReportingTypeConverterLoader();
        ReportingTypeConverterRegistry registry = new ReportingTypeConverterRegistry();
        try {
            String[] errors;
            loader.load((TypeConverterRegistry)registry);
            for (String error : errors = registry.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (this.generateReports) {
            this.generateReport(loader.getTypeConversions());
        }
    }

    protected void generateReport(ReportingTypeConverterLoader.TypeMapping[] mappings) throws MojoExecutionException {
        File f = this.reportsDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        File report = new File(f, "camel-converters.txt");
        FileWriter fw = null;
        try {
            fw = new FileWriter(report);
            fw.write("Camel Type Converter definitions\n");
            fw.write(LINE_SEPARATOR);
            HashSet<String> packages = new HashSet<String>();
            HashSet<String> classes = new HashSet<String>();
            StringBuffer buffer = new StringBuffer();
            Class prevFrom = null;
            Class prevTo = null;
            for (ReportingTypeConverterLoader.TypeMapping mapping : mappings) {
                boolean ignored = false;
                Class from = mapping.getFromType();
                Class to = mapping.getToType();
                if (ObjectHelper.equal((Object)from, prevFrom) && ObjectHelper.equal((Object)to, prevTo)) {
                    ignored = true;
                    buffer.append(" ");
                }
                prevFrom = from;
                prevTo = to;
                Method method = mapping.getMethod();
                Class<?> methodClass = method.getDeclaringClass();
                packages.add(methodClass.getPackage().getName());
                classes.add(methodClass.getName());
                buffer.append(from.getSimpleName() + "=>" + to.getSimpleName());
                buffer.append(" [" + mapping.getConverterType().getSimpleName());
                buffer.append("(" + methodClass.getName() + "." + method.getName() + "())]");
                if (ignored) {
                    buffer.append(" - IGNORED replaced by conversion method above");
                }
                fw.write(buffer.toString() + "\n");
                buffer.setLength(0);
            }
            String summary = "Found " + mappings.length + " type conversion methods in " + classes.size() + " classes from " + packages.size() + " packages.";
            fw.write(LINE_SEPARATOR);
            fw.write(summary + "\n");
            this.getLog().info((CharSequence)summary);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating report file " + report, (Exception)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

