/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.dataformat.tagsoup.TidyMarkupDataFormat;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.w3c.dom.Node;

public class HtmlToPdfMojo
extends AbstractMojo {
    private String page;
    private String pdf;
    private String[] styleSheets;
    private String head;
    private String replaceToken;
    private String replaceValue;
    private String contentDivClass = "wiki-content";
    private String[] princeArgs;
    private boolean errorOnConverionFailure;
    private boolean errorOnDownloadFailure;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String type;
    private String classifier;

    public void execute() throws MojoExecutionException {
        File outputDir = new File(this.pdf).getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try {
            String content = this.downloadContent();
            if (content == null) {
                this.storeDummyFile();
                return;
            }
            this.storeHTMLFile(content);
            if (this.convert() == 0) {
                File pdfFile = new File(this.getPDFFileName());
                this.projectHelper.attachArtifact(this.project, this.type, this.classifier, pdfFile);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Download of '" + this.page + "' failed: " + e.getMessage(), e);
        }
    }

    private int convert() throws CommandLineException, MojoExecutionException {
        Commandline.Argument arg;
        this.getLog().info((CharSequence)"Converting to PDF with prince...");
        Commandline cl = new Commandline("prince");
        if (this.princeArgs != null) {
            for (int i = 0; i < this.princeArgs.length; ++i) {
                arg = new Commandline.Argument();
                arg.setValue(this.princeArgs[i]);
                cl.addArg((Arg)arg);
            }
        }
        arg = new Commandline.Argument();
        arg.setValue(this.getHTMLFileName());
        cl.addArg((Arg)arg);
        arg = new Commandline.Argument();
        arg.setValue(this.getPDFFileName());
        cl.addArg((Arg)arg);
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                HtmlToPdfMojo.this.getLog().info((CharSequence)("[prince] " + line));
            }
        };
        this.getLog().info((CharSequence)"About to execute PrinceXml (see www.princexml.com)");
        String[] lines = cl.getCommandline();
        StringBuffer buffer = new StringBuffer();
        for (String line : lines) {
            buffer.append(" ");
            buffer.append(line);
        }
        this.getLog().info((CharSequence)buffer);
        int rc = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)out);
        if (rc == 0) {
            this.getLog().info((CharSequence)("Stored: " + this.getPDFFileName()));
        } else {
            if (this.errorOnConverionFailure) {
                throw new MojoExecutionException("PDF Conversion failed rc=" + rc);
            }
            this.getLog().error((CharSequence)("PDF Conversion failed due to return code: " + rc));
        }
        return rc;
    }

    private String getPDFFileName() {
        return this.pdf;
    }

    private void storeDummyFile() throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.getHTMLFileName())));
        out.println("<html>");
        out.println("<body>Download of " + this.page + " failed</body>");
        out.close();
        this.getLog().info((CharSequence)("Stored dummy file: " + this.getHTMLFileName() + " since download of " + this.page + " failed."));
    }

    private void storeHTMLFile(String content) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.getHTMLFileName())));
        out.println("<html>");
        out.println("<head>");
        out.println("   <base href=\"" + this.page + "\"/>");
        if (this.head != null) {
            out.println(this.head);
        }
        if (this.styleSheets != null) {
            for (int i = 0; i < this.styleSheets.length; ++i) {
                out.println("   <link href=\"" + this.styleSheets[i] + "\" rel=\"stylesheet\" type=\"text/css\"/>");
            }
        }
        out.println("</head>");
        if (this.replaceToken != null && this.replaceValue != null) {
            content = content.replaceAll(this.replaceToken, this.replaceValue);
        }
        out.println("<body>" + content + "</body>");
        out.close();
        this.getLog().info((CharSequence)("Stored: " + this.getHTMLFileName()));
    }

    private String getHTMLFileName() {
        String name = this.getPDFFileName();
        if (name.endsWith(".pdf")) {
            name = name.substring(0, name.length() - 4);
        }
        return name + ".html";
    }

    private String downloadContent() throws MalformedURLException, MojoExecutionException {
        String contentTag = "<div class=\"" + this.contentDivClass + "\"";
        this.getLog().info((CharSequence)("Downloading: " + this.page));
        URL url = new URL(this.page);
        try {
            TidyMarkupDataFormat dataFormat = new TidyMarkupDataFormat();
            dataFormat.setMethod("html");
            Node doc = dataFormat.asNodeTidyMarkup((InputStream)new BufferedInputStream(url.openStream()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node nd = (Node)xpath.evaluate("//div[@class='" + this.contentDivClass + "']", doc, XPathConstants.NODE);
            if (nd != null) {
                return new XmlConverter().toString(nd, null);
            }
        }
        catch (Throwable e) {
            if (this.errorOnDownloadFailure) {
                throw new MojoExecutionException("Download or validation of '" + this.page + "' failed: " + e);
            }
            this.getLog().error((CharSequence)("Download or validation of '" + this.page + "' failed: " + e));
            return null;
        }
        throw new MojoExecutionException("The '" + this.page + "' page did not have a " + contentTag + " element.");
    }
}

