/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se.state;

import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.CXFServiceUnitManager;
import org.apache.cxf.jbi.se.state.ServiceEngineStateMachine;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBITransportFactory;

public abstract class AbstractServiceEngineStateMachine
implements ServiceEngineStateMachine {
    static final String CXF_CONFIG_FILE = "cxf.xml";
    static final String PROVIDER_PROP = "javax.xml.ws.spi.Provider";
    static JBITransportFactory jbiTransportFactory;
    static CXFServiceUnitManager suManager;
    static ComponentContext ctx;
    static Bus bus;
    private static final Logger LOG;

    public void changeState(ServiceEngineStateMachine.SEOperation operation, ComponentContext context) throws JBIException {
    }

    void configureJBITransportFactory(DeliveryChannel chnl, CXFServiceUnitManager mgr) throws BusException, JBIException {
        this.getTransportFactory();
        JBITransportFactory.setDeliveryChannel((DeliveryChannel)chnl);
    }

    void registerJBITransport(Bus argBus, CXFServiceUnitManager mgr) throws JBIException {
        try {
            this.getTransportFactory().setBus(argBus);
        }
        catch (Exception ex) {
            LOG.severe(new Message("SE.FAILED.REGISTER.TRANSPORT.FACTORY", LOG, new Object[0]).toString());
            throw new JBIException(new Message("SE.FAILED.REGISTER.TRANSPORT.FACTORY", LOG, new Object[0]).toString(), (Throwable)ex);
        }
    }

    public static CXFServiceUnitManager getSUManager() {
        return suManager;
    }

    protected JBITransportFactory getTransportFactory() throws JBIException, BusException {
        assert (bus != null);
        if (jbiTransportFactory == null) {
            jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
            jbiTransportFactory.setBus(bus);
            JBITransportFactory.setDeliveryChannel((DeliveryChannel)ctx.getDeliveryChannel());
        }
        return jbiTransportFactory;
    }

    static {
        LOG = LogUtils.getL7dLogger(AbstractServiceEngineStateMachine.class);
    }
}

