/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;

public class RetransmissionCallback
implements CachedOutputStreamCallback {
    private static final Logger LOG = LogUtils.getL7dLogger(RetransmissionCallback.class);
    Message message;
    RMManager manager;

    RetransmissionCallback(Message m, RMManager mgr) {
        this.message = m;
        this.manager = mgr;
    }

    public void onClose(CachedOutputStream cos) {
        OutputStream os = cos.getOut();
        if (os instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)os;
            this.message.put((Object)"org.apache.cxf.ws.rm.outputstream", (Object)bos);
            this.manager.getRetransmissionQueue().addUnacknowledged(this.message);
            RMStore store = this.manager.getStore();
            if (null != store) {
                AddressingPropertiesImpl maps;
                Source s = this.manager.getSource(this.message);
                RMProperties rmps = RMContextUtils.retrieveRMProperties(this.message, true);
                Identifier sid = rmps.getSequence().getIdentifier();
                SourceSequence ss = s.getSequence(sid);
                RMMessage msg = new RMMessage();
                msg.setMessageNumber(rmps.getSequence().getMessageNumber());
                if (!MessageUtils.isRequestor((Message)this.message) && null != (maps = RMContextUtils.retrieveMAPs(this.message, false, true)) && null != maps.getTo()) {
                    msg.setTo(maps.getTo().getValue());
                }
                msg.setContent(bos.toByteArray());
                store.persistOutgoing(ss, msg);
            }
        } else {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_CACHED_STREAM", LOG, new Object[]{os.getClass()}));
        }
    }

    public void onFlush(CachedOutputStream cos) {
    }
}

