/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class ProcessorTestBase
extends Assert {
    protected ToolContext env = new ToolContext();
    protected File output;

    @Before
    public void setUp() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(".");
        this.output = new File(url.toURI());
        this.output = new File(this.output, "/resources");
        FileUtils.mkDir((File)this.output);
    }

    @After
    public void tearDown() {
        FileUtils.removeDir((File)this.output);
        this.output = null;
        this.env = null;
    }

    protected String getClassPath() throws URISyntaxException {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        StringBuffer classPath = new StringBuffer();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                File file = new File(url.toURI());
                String filename = file.getAbsolutePath();
                if (filename.indexOf("junit") != -1) continue;
                classPath.append(filename);
                classPath.append(System.getProperty("path.separator"));
            }
        }
        return classPath.toString();
    }

    protected String getLocation(String wsdlFile) throws URISyntaxException {
        return ((Object)((Object)this)).getClass().getResource(wsdlFile).toString();
    }

    protected void assertFileEquals(String f1, String f2) {
        this.assertFileEquals(new File(f1), new File(f2));
    }

    protected void assertFileEquals(File location1, File location2) {
        String str1 = this.getStringFromFile(location1);
        String str2 = this.getStringFromFile(location2);
        StringTokenizer st1 = new StringTokenizer(str1, " \t\n\r\f(),");
        StringTokenizer st2 = new StringTokenizer(str2, " \t\n\r\f(),");
        ArrayList<String> unmatched = new ArrayList<String>();
        while (st1.hasMoreTokens()) {
            String tok1 = st1.nextToken();
            String tok2 = null;
            if (unmatched.contains(tok1)) {
                unmatched.remove(tok1);
                continue;
            }
            while (st2.hasMoreTokens() && !tok1.equals(tok2 = st2.nextToken())) {
                unmatched.add(tok2);
            }
            ProcessorTestBase.assertEquals((String)("Compare failed " + location1.getAbsolutePath() + " != " + location2.getAbsolutePath()), (Object)tok1, (Object)tok2);
        }
        ProcessorTestBase.assertTrue((!st1.hasMoreTokens() ? 1 : 0) != 0);
        ProcessorTestBase.assertTrue((!st2.hasMoreTokens() ? 1 : 0) != 0);
        ProcessorTestBase.assertTrue((String)"Files did not match", (boolean)unmatched.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringFromFile(File location) {
        FileInputStream is = null;
        String result = null;
        try {
            is = new FileInputStream(location);
            result = this.normalizeCRLF(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    private String normalizeCRLF(InputStream instream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(instream));
        StringBuffer result = new StringBuffer();
        String line = null;
        try {
            line = in.readLine();
            while (line != null) {
                String[] tok = line.split("\\s");
                for (int x = 0; x < tok.length; ++x) {
                    String token = tok[x];
                    result.append("  " + token);
                }
                line = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String rtn = result.toString();
        rtn = this.ignoreTokens(rtn, "<!--", "-->");
        rtn = this.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private String ignoreTokens(String contents, String startToken, String endToken) {
        String rtn = contents;
        int headerIndexStart = rtn.indexOf(startToken);
        int headerIndexEnd = rtn.indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = rtn.substring(0, headerIndexStart - 1) + rtn.substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }
}

