/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;

public class FileWriterUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(FileWriterUtil.class);
    private final File target;

    public FileWriterUtil(String targetDir) throws ToolException {
        this.target = new File(targetDir);
        if (!this.target.exists() || !this.target.isDirectory()) {
            Message msg = new Message("DIRECTORY_NOT_EXIST", LOG, new Object[]{this.target});
            throw new ToolException(msg);
        }
    }

    public File getFileToWrite(String packageName, String fileName) throws IOException {
        File dir = this.buildDir(packageName);
        File fn = new File(dir, fileName);
        if (fn.exists() && !fn.delete()) {
            throw new IOException(fn + ": Can't delete previous version");
        }
        return fn;
    }

    public static Writer getWriter(File fn) throws IOException {
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fn)), "UTF-8");
    }

    public static Writer getWriter(File fn, String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fn)), encoding);
    }

    public Writer getWriter(String packageName, String fileName) throws IOException {
        return FileWriterUtil.getWriter(this.getFileToWrite(packageName, fileName));
    }

    public boolean isCollision(String packageName, String fileName) throws ToolException {
        File dir = this.buildDir(packageName);
        return this.fileExist(dir, fileName);
    }

    private File buildDir(String packageName) {
        File dir = packageName == null ? this.target : new File(this.target, this.toDir(packageName));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private boolean fileExist(File dir, String fileName) {
        return new File(dir, fileName).exists();
    }

    private String toDir(String packageName) {
        return packageName.replace('.', File.separatorChar);
    }
}

