/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPolicyImpl
implements EndpointPolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EndpointPolicyImpl.class);
    private Policy policy;
    private Collection<Assertion> chosenAlternative;
    private Collection<Assertion> vocabulary;
    private Collection<Assertion> faultVocabulary;
    private List<Interceptor> interceptors;
    private List<Interceptor> faultInterceptors;

    public Policy getPolicy() {
        return this.policy;
    }

    public Collection<Assertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    public Collection<Assertion> getVocabulary() {
        return this.vocabulary;
    }

    public Collection<Assertion> getFaultVocabulary() {
        return this.faultVocabulary;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public List<Interceptor> getFaultInterceptors() {
        return this.faultInterceptors;
    }

    void initialise(EndpointInfo ei, boolean isRequestor, PolicyEngineImpl engine, Assertor assertor) {
        this.initialisePolicy(ei, engine);
        this.chooseAlternative(engine, assertor);
        this.initialiseVocabulary(ei, isRequestor, engine);
        this.initialiseInterceptors(ei, isRequestor, engine);
    }

    void initialisePolicy(EndpointInfo ei, PolicyEngineImpl engine) {
        this.policy = engine.getAggregatedServicePolicy(ei.getService());
        this.policy = this.policy.merge(engine.getAggregatedEndpointPolicy(ei));
        this.policy = (Policy)this.policy.normalize(true);
    }

    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor) {
        Collection alternative = engine.getAlternativeSelector().selectAlternative(this.policy, (PolicyEngine)engine, assertor);
        if (null == alternative) {
            throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    void initialiseVocabulary(EndpointInfo ei, boolean requestor, PolicyEngineImpl engine) {
        this.vocabulary = new ArrayList<Assertion>();
        if (requestor) {
            this.faultVocabulary = new ArrayList<Assertion>();
        }
        for (Assertion a : this.getChosenAlternative()) {
            if (a.isOptional()) continue;
            this.vocabulary.add(a);
            if (null == this.faultVocabulary) continue;
            this.faultVocabulary.add(a);
        }
        for (BindingOperationInfo boi : ei.getBinding().getOperations()) {
            Policy p = engine.getAggregatedOperationPolicy(boi);
            Collection<Assertion> c = engine.getAssertions((PolicyComponent)p, false);
            this.vocabulary.addAll(c);
            if (null != this.faultVocabulary) {
                this.faultVocabulary.addAll(c);
            }
            if (!requestor) {
                p = engine.getAggregatedMessagePolicy(boi.getInput());
                this.vocabulary.addAll(engine.getAssertions((PolicyComponent)p, false));
                continue;
            }
            if (null == boi.getOutput()) continue;
            p = engine.getAggregatedMessagePolicy(boi.getOutput());
            this.vocabulary.addAll(engine.getAssertions((PolicyComponent)p, false));
            for (BindingFaultInfo bfi : boi.getFaults()) {
                p = engine.getAggregatedFaultPolicy(bfi);
                this.faultVocabulary.addAll(engine.getAssertions((PolicyComponent)p, false));
            }
        }
    }

    void initialiseInterceptors(EndpointInfo ei, boolean requestor, PolicyEngineImpl engine) {
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        this.interceptors = new ArrayList<Interceptor>();
        if (requestor) {
            this.faultInterceptors = new ArrayList<Interceptor>();
        }
        HashSet<QName> v = new HashSet<QName>();
        for (Assertion a : this.vocabulary) {
            v.add(a.getName());
        }
        for (QName qn : v) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
            if (null == pp) continue;
            this.interceptors.addAll(pp.getInInterceptors());
        }
        if (!requestor) {
            return;
        }
        HashSet<QName> faultV = new HashSet<QName>();
        for (Assertion a : this.faultVocabulary) {
            faultV.add(a.getName());
        }
        for (QName qn : faultV) {
            PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
            if (null == pp) continue;
            this.faultInterceptors.addAll(pp.getInFaultInterceptors());
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<Assertion> c) {
        this.chosenAlternative = c;
    }

    void setVocabulary(Collection<Assertion> v) {
        this.vocabulary = v;
    }

    void setFaultVocabulary(Collection<Assertion> v) {
        this.faultVocabulary = v;
    }

    void setInterceptors(List<Interceptor> in) {
        this.interceptors = in;
    }

    void setFaultInterceptors(List<Interceptor> inFault) {
        this.faultInterceptors = inFault;
    }
}

