/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    private static final Logger LOG = Logger.getLogger(WSS4JInInterceptor.class.getName());
    private static final Logger TIME_LOG = Logger.getLogger(WSS4JInInterceptor.class.getName() + "-Time");

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public WSS4JInInterceptor(Map<String, String> properties) {
        this();
        this.setProperties(properties);
    }

    public void handleMessage(SoapMessage msg) throws Fault {
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeLog = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInSecurityHandler: enter invoke()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (doTimeLog) {
            t0 = System.currentTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            WSSecurityEngineResult actionResult;
            reqData.setMsgContext((Object)msg);
            Vector actions = new Vector();
            String action = this.getAction(msg, version);
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            SOAPMessage doc = (SOAPMessage)msg.getContent(SOAPMessage.class);
            if (doc == null) {
                throw new SoapFault(new Message("NO_SAAJ_DOC", LOG, new Object[0]), version.getReceiver());
            }
            CallbackHandler cbHandler = this.getCallback(reqData, doAction);
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (doTimeLog) {
                t1 = System.currentTimeMillis();
            }
            try {
                wsResult = secEngine.processSecurityHeader((Document)doc.getSOAPPart(), actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new SoapFault(new Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)ex, version.getSender());
            }
            if (doTimeLog) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                LOG.warning("Request does not contain required Security header");
                throw new SoapFault(new Message("NO_SECURITY", LOG, new Object[0]), version.getSender());
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)2)) != null) {
                X509Certificate returnCert = actionResult.getCertificate();
                if (returnCert != null && !this.verifyTrust(returnCert, reqData)) {
                    LOG.warning("The certificate used for the signature is not trusted");
                    throw new SoapFault(new Message("UNTRUSTED_CERT", LOG, new Object[0]), version.getSender());
                }
                msg.put(SIGNATURE_RESULT, (Object)actionResult);
            }
            if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)32)) != null) {
                Timestamp timestamp = actionResult.getTimestamp();
                if (timestamp != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                    LOG.warning("The timestamp could not be validated");
                    throw new SoapFault(new Message("INVALID_TIMESTAMP", LOG, new Object[0]), version.getSender());
                }
                msg.put(TIMESTAMP_RESULT, (Object)actionResult);
            }
            if (!this.checkReceiverResults(wsResult, actions)) {
                LOG.warning("Security processing failed (actions mismatch)");
                throw new SoapFault(new Message("ACTION_MISMATCH", LOG, new Object[0]), version.getSender());
            }
            this.doResults(msg, actor, doc, wsResult);
            if (doTimeLog) {
                t3 = System.currentTimeMillis();
                TIME_LOG.fine("Receive request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " header, cert verify, timestamp= " + (t3 - t2) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSS4JInHandler: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            LOG.log(Level.WARNING, "", e);
            throw new SoapFault(new Message("WSSECURITY_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void doResults(SoapMessage msg, String actor, SOAPMessage doc, Vector wsResult) throws SOAPException, XMLStreamException {
        Vector<WSHandlerResult> results = (Vector<WSHandlerResult>)msg.get((Object)"RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            msg.put("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        SOAPBody body = doc.getSOAPBody();
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource((Node)body));
        int evt = reader.next();
        while (reader.hasNext() && (evt == 2 || evt == 1)) {
            evt = reader.next();
        }
        msg.setContent(XMLStreamReader.class, (Object)reader);
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get((Object)"action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    private CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            cbHandler = this.getPasswordCB(reqData);
        }
        return cbHandler;
    }
}

