/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.util.NamespaceHelper;

public final class TypeUtil {
    public static final Log LOG = LogFactory.getLog(TypeUtil.class);

    private TypeUtil() {
    }

    public static Type getReadType(XMLStreamReader xsr, Context context, Type type) {
        QName overrideTypeName;
        if (!context.isReadXsiTypes()) {
            return type;
        }
        String overrideType = xsr.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (overrideType != null && !(overrideTypeName = NamespaceHelper.createQName(xsr.getNamespaceContext(), overrideType)).equals(type.getSchemaType())) {
            Type type2 = type.getTypeMapping().getType(overrideTypeName);
            if (type2 == null) {
                LOG.info((Object)("xsi:type=\"" + overrideTypeName + "\" was specified, but no corresponding Type was registered; defaulting to " + type.getSchemaType()));
            } else {
                type = type2;
            }
        }
        return type;
    }

    public static Type getWriteType(Context context, Object value, Type type) {
        List<String> l;
        if (value != null && type != null && type.getTypeClass() != value.getClass() && (l = context.getOverrideTypes()) != null && l.contains(value.getClass().getName())) {
            type = type.getTypeMapping().getType(value.getClass());
        }
        return type;
    }
}

