/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.coloc.ColocInInterceptor;
import org.apache.cxf.binding.coloc.ColocUtil;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.ChainInitiationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColocMessageObserver
extends ChainInitiationObserver {
    private static final Logger LOG = Logger.getLogger(ColocMessageObserver.class.getName());
    private static final String COLOCATED = Message.class.getName() + ".COLOCATED";

    public ColocMessageObserver(Endpoint endpoint, Bus bus) {
        super(endpoint, bus);
    }

    @Override
    public void onMessage(Message m) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Processing Message at collocated endpoint.  Request message: " + m);
        }
        ExchangeImpl ex = new ExchangeImpl();
        this.setExchangeProperties(ex, m);
        Message inMsg = this.endpoint.getBinding().createMessage();
        MessageImpl.copyContent(m, inMsg);
        inMsg.putAll(m);
        inMsg.put(COLOCATED, Boolean.TRUE);
        inMsg.put("org.apache.cxf.client", Boolean.FALSE);
        inMsg.put("org.apache.cxf.message.inbound", Boolean.TRUE);
        OperationInfo oi = ex.get(OperationInfo.class);
        if (oi != null) {
            inMsg.put(MessageInfo.class, oi.getInput());
        }
        ex.setInMessage(inMsg);
        inMsg.setExchange(ex);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Build inbound interceptor chain.");
        }
        TreeSet<Phase> phases = new TreeSet<Phase>(this.bus.getExtension(PhaseManager.class).getInPhases());
        ColocUtil.setPhases(phases, "user-logical", "invoke");
        InterceptorChain chain = ColocUtil.getInInterceptorChain(ex, phases);
        chain.add(this.addColocInterceptors());
        inMsg.setInterceptorChain(chain);
        chain.doIntercept(inMsg);
        this.setOutBoundMessage(ex, m.getExchange());
    }

    protected void setOutBoundMessage(Exchange from, Exchange to) {
        if (from.getOutFaultMessage() != null) {
            to.setInFaultMessage(from.getOutFaultMessage());
        } else {
            to.setInMessage(from.getOutMessage());
        }
    }

    @Override
    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Bus.class, this.bus);
        exchange.put(Endpoint.class, this.endpoint);
        exchange.put(Service.class, this.endpoint.getService());
        exchange.put(Binding.class, this.endpoint.getBinding());
        QName opName = (QName)m.get("javax.xml.ws.wsdl.operation");
        BindingInfo bi = this.endpoint.getEndpointInfo().getBinding();
        BindingOperationInfo boi = bi.getOperation(opName);
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        exchange.put(BindingInfo.class, bi);
        exchange.put(BindingOperationInfo.class, boi);
        exchange.put(OperationInfo.class, boi.getOperationInfo());
    }

    protected List<Interceptor> addColocInterceptors() {
        ArrayList<Interceptor> list = new ArrayList<Interceptor>();
        list.add(new ColocInInterceptor());
        return list;
    }
}

