/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class RPCInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(RPCInInterceptor.class.getName());

    public RPCInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    private BindingOperationInfo getOperation(Message message, QName opName) {
        return ServiceModelUtil.getOperation(message.getExchange(), opName);
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("RPCInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        BindingOperationInfo operation = null;
        if (!StaxUtils.toNextElement(xmlReader)) {
            message.setContent(Exception.class, new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        if (message.getExchange().get(BindingOperationInfo.class) == null) {
            operation = this.getOperation(message, new QName(xmlReader.getNamespaceURI(), opName));
            if (operation == null) {
                new BareInInterceptor().handleMessage(message);
                return;
            }
            message.getExchange().put(BindingOperationInfo.class, operation);
            message.getExchange().put(OperationInfo.class, operation.getOperationInfo());
        } else {
            operation = message.getExchange().get(BindingOperationInfo.class);
        }
        DataReader<XMLStreamReader> dr = this.getDataReader(message, XMLStreamReader.class);
        MessageInfo msg = !this.isRequestor(message) ? operation.getOperationInfo().getInput() : operation.getOperationInfo().getOutput();
        ArrayList<Object> parameters = new ArrayList<Object>();
        StaxUtils.nextEvent(xmlReader);
        while (StaxUtils.toNextElement(xmlReader)) {
            QName name = xmlReader.getName();
            MessagePartInfo part = null;
            for (MessagePartInfo mpi : msg.getMessageParts()) {
                if (!mpi.getName().getLocalPart().equals(name.getLocalPart())) continue;
                part = mpi;
                break;
            }
            if (part == null) {
                throw new SoapFault("Parameter " + xmlReader.getName() + " does not exist!", ((SoapMessage)message).getVersion().getSender());
            }
            Object param = dr.read(part, xmlReader);
            parameters.add(param);
        }
        message.setContent(List.class, parameters);
    }
}

