/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

public class RPCOutInterceptor
extends AbstractOutDatabindingInterceptor {
    public RPCOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(Message message) {
        try {
            NSStack nsStack = new NSStack();
            nsStack.push();
            BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class.getName());
            assert (operation.getName() != null);
            XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
            this.addOperationNode(nsStack, message, xmlWriter);
            List<MessagePartInfo> parts = null;
            parts = !this.isRequestor(message) ? operation.getOutput().getMessageParts() : operation.getInput().getMessageParts();
            List objs = message.getContent(List.class);
            if (objs == null) {
                return;
            }
            this.writeParts(message, message.getExchange(), operation, objs, parts);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    protected String addOperationNode(NSStack nsStack, Message message, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String responseSuffix = !this.isRequestor(message) ? "Response" : "";
        BindingOperationInfo boi = message.getExchange().get(BindingOperationInfo.class);
        String ns = boi.getName().getNamespaceURI();
        nsStack.add(ns);
        String prefix = nsStack.getPrefix(ns);
        StaxUtils.writeStartElement(xmlWriter, prefix, boi.getName().getLocalPart() + responseSuffix, ns);
        return ns;
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return message.getContent(XMLStreamWriter.class);
    }
}

