/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    private static final Object[] NO_PARAMETERS = new Object[0];

    private LogUtils() {
    }

    public static Logger getL7dLogger(Class<?> cls) {
        return Logger.getLogger(cls.getName(), BundleUtils.getBundleName(cls));
    }

    public static Logger getL7dLogger(Class<?> cls, String name) {
        return Logger.getLogger(cls.getName(), BundleUtils.getBundleName(cls, name));
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object parameter) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameter);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable, Object ... parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters);
            LogUtils.doLog(logger, level, formattedMessage, throwable);
        }
    }

    public static void log(Logger logger, Level level, String message) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), NO_PARAMETERS);
            LogUtils.doLog(logger, level, formattedMessage, null);
        }
    }

    public static void log(Logger logger, Level level, String message, Throwable throwable) {
        LogUtils.log(logger, level, message, throwable, NO_PARAMETERS);
    }

    public static void log(Logger logger, Level level, String message, Object parameter) {
        LogUtils.log(logger, level, message, new Object[]{parameter});
    }

    public static void log(Logger logger, Level level, String message, Object[] parameters) {
        if (logger.isLoggable(level)) {
            String formattedMessage = MessageFormat.format(LogUtils.localize(logger, message), parameters);
            LogUtils.doLog(logger, level, formattedMessage, null);
        }
    }

    private static void doLog(Logger log, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(log.getName());
        record.setResourceBundleName(log.getResourceBundleName());
        record.setResourceBundle(log.getResourceBundle());
        if (t != null) {
            record.setThrown(t);
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String cname = LogUtils.class.getName();
        for (int x = 0; x < stack.length; ++x) {
            StackTraceElement frame = stack[x];
            if (frame.getClassName().equals(cname)) continue;
            record.setSourceClassName(frame.getClassName());
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
        log.log(record);
    }

    private static String localize(Logger logger, String message) {
        ResourceBundle bundle = logger.getResourceBundle();
        return bundle != null ? bundle.getString(message) : message;
    }
}

