/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataWriter
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataWriter.class);

    @Override
    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        this.write(obj, output);
    }

    @Override
    public void write(Object obj, XMLStreamWriter writer) {
        try {
            Source s = (Source)obj;
            if (s instanceof DOMSource && ((DOMSource)s).getNode() == null) {
                return;
            }
            XMLStreamReader reader = StaxUtils.createXMLStreamReader(s);
            StaxUtils.copy(reader, writer);
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void setSchema(Schema s) {
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }
}

