/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend.spring;

import java.util.List;
import java.util.Map;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ServerFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String IMPLEMENTOR = "implementor";

    public ServerFactoryBeanDefinitionParser() {
        this.setBeanClass(ServerFactoryBean.class);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue("properties", (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("invoker".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.invoker");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        super.doParse(element, ctx, bean);
        bean.setInitMethodName("create");
        bean.setLazyInit(false);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, String name, String val) {
        if (name.equals(IMPLEMENTOR)) {
            this.loadImplementor(bean, val);
        } else {
            super.mapAttribute(bean, name, val);
        }
    }

    private void loadImplementor(BeanDefinitionBuilder bean, String val) {
        if (StringUtils.hasText((String)val)) {
            if (val.startsWith("#")) {
                bean.addPropertyReference(IMPLEMENTOR, val.substring(1));
            } else {
                try {
                    bean.addPropertyValue(IMPLEMENTOR, ClassLoaderUtils.loadClass(val, ((Object)((Object)this)).getClass()).newInstance());
                }
                catch (Exception e) {
                    throw new FatalBeanException("Could not load class: " + val, (Throwable)e);
                }
            }
        }
    }

    protected boolean hasBusProperty() {
        return true;
    }
}

