/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.io.CachedOutputStreamCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedOutputStream
extends OutputStream {
    protected OutputStream currentStream;
    private long threshold = 65536L;
    private int totalLength;
    private boolean inmem;
    private File tempFile;
    private File outputDir;
    private List<CachedOutputStreamCallback> callbacks;

    public CachedOutputStream(PipedInputStream stream) throws IOException {
        this.currentStream = new PipedOutputStream(stream);
        this.inmem = true;
    }

    public CachedOutputStream() {
        this.currentStream = new ByteArrayOutputStream();
        this.inmem = true;
    }

    public void registerCallback(CachedOutputStreamCallback cb) {
        if (null == this.callbacks) {
            this.callbacks = new ArrayList<CachedOutputStreamCallback>();
        }
        this.callbacks.add(cb);
    }

    public void deregisterCallback(CachedOutputStreamCallback cb) {
        if (null != this.callbacks) {
            this.callbacks.remove(cb);
        }
    }

    public List<CachedOutputStreamCallback> getCallbacks() {
        return this.callbacks == null ? null : Collections.unmodifiableList(this.callbacks);
    }

    protected void doFlush() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onFlush(this);
            }
        }
        this.doFlush();
    }

    protected void doClose() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        if (null != this.callbacks) {
            for (CachedOutputStreamCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.currentStream.close();
        this.dispose();
        this.doClose();
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetOut(OutputStream out, boolean copyOldContent) throws IOException {
        if (this.currentStream instanceof CachedOutputStream) {
            CachedOutputStream ac = (CachedOutputStream)this.currentStream;
            InputStream in = ac.getInputStream();
            CachedOutputStream.copyStream(in, out, (int)this.threshold);
        } else if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.currentStream;
                if (copyOldContent && byteOut.size() > 0) {
                    byteOut.writeTo(out);
                }
            } else {
                if (!(this.currentStream instanceof PipedOutputStream)) throw new IOException("Unknown format of currentStream");
                PipedOutputStream pipeOut = (PipedOutputStream)this.currentStream;
                CachedOutputStream.copyStream(new PipedInputStream(pipeOut), out, (int)this.threshold);
            }
        } else {
            this.currentStream.close();
            FileInputStream fin = new FileInputStream(this.tempFile);
            if (copyOldContent) {
                CachedOutputStream.copyStream(fin, out, (int)this.threshold);
            }
        }
        this.currentStream = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamWithBase64Encoding(InputStream in, OutputStream out, int bufferSize) throws Exception {
        OutputStreamWriter osw = new OutputStreamWriter(out);
        byte[] buffer = new byte[bufferSize];
        try {
            int n = in.read(buffer, 0, bufferSize);
            while (n > 0) {
                Base64Utility.encode(buffer, 0, n, osw);
                n = in.read(buffer, 0, bufferSize);
            }
        }
        finally {
            in.close();
        }
    }

    public OutputStream getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        return "[" + super.toString() + " Content: " + this.currentStream.toString() + "]";
    }

    protected void onWrite() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.onWrite();
        this.totalLength += len;
        if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
        this.currentStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.onWrite();
        this.totalLength += b.length;
        if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
        this.currentStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.onWrite();
        ++this.totalLength;
        if (this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
        this.currentStream.write(b);
    }

    private void createFileOutputStream() throws IOException {
        byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
        this.tempFile = this.outputDir == null ? File.createTempFile("att", "tmp") : File.createTempFile("att", "tmp", this.outputDir);
        this.tempFile.deleteOnExit();
        this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        this.currentStream.write(bytes);
        this.inmem = false;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            if (this.currentStream instanceof PipedOutputStream) {
                return new PipedInputStream((PipedOutputStream)this.currentStream);
            }
            return null;
        }
        try {
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    public void dispose() {
        if (!this.inmem) {
            this.tempFile.delete();
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
        this.createFileOutputStream();
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }
}

